/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.FileSystemValidator$;
import org.apache.flink.table.descriptors.OldCsvValidator;
import org.apache.flink.table.descriptors.OldCsvValidator$;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d3Q!\u0001\u0002\u0002\u00025\u0011\u0011dQ:w)\u0006\u0014G.Z*pkJ\u001cWMR1di>\u0014\u0018PQ1tK*\u00111\u0001B\u0001\bg>,(oY3t\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0017!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003%1\u0017m\u0019;pe&,7/\u0003\u0002\u001c1\taA+\u00192mK\u001a\u000b7\r^8ss\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\u0006E\u0001!\teI\u0001\u0010e\u0016\fX/\u001b:fI\u000e{g\u000e^3yiR\tA\u0005\u0005\u0003&Q)RS\"\u0001\u0014\u000b\u0005\u001d\u0012\u0012\u0001B;uS2L!!\u000b\u0014\u0003\u00075\u000b\u0007\u000f\u0005\u0002,c9\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u0001T\u0006C\u00036\u0001\u0011\u0005c'A\ntkB\u0004xN\u001d;fIB\u0013x\u000e]3si&,7\u000fF\u00018!\r)\u0003HK\u0005\u0003s\u0019\u0012A\u0001T5ti\")1\b\u0001C\ty\u0005\t2M]3bi\u0016$\u0016M\u00197f'>,(oY3\u0015\u0007u\u0002U\t\u0005\u0002!}%\u0011qH\u0001\u0002\u000f\u0007N4H+\u00192mKN{WO]2f\u0011\u0015\t%\b1\u0001C\u0003-I7o\u0015;sK\u0006l\u0017N\\4\u0011\u00051\u001a\u0015B\u0001#.\u0005\u001d\u0011un\u001c7fC:DQA\u0012\u001eA\u0002\u0011\n!\u0002\u001d:pa\u0016\u0014H/[3t\u0001")
public abstract class CsvTableSourceFactoryBase
implements TableFactory {
    /*
     * WARNING - void declaration
     */
    public Map<String, String> requiredContext() {
        void var1_1;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", FileSystemValidator$.MODULE$.CONNECTOR_TYPE_VALUE());
        context.put("format.type", OldCsvValidator$.MODULE$.FORMAT_TYPE_VALUE());
        context.put("connector.property-version", "1");
        context.put("format.property-version", "1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> supportedProperties() {
        void var1_1;
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OldCsvValidator$.MODULE$.FORMAT_FIELDS(), "type"})));
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OldCsvValidator$.MODULE$.FORMAT_FIELDS(), "name"})));
        properties.add(OldCsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER());
        properties.add(OldCsvValidator$.MODULE$.FORMAT_LINE_DELIMITER());
        properties.add(OldCsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER());
        properties.add(OldCsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX());
        properties.add(OldCsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE());
        properties.add(OldCsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS());
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaValidator$.MODULE$.SCHEMA(), "type"})));
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaValidator$.MODULE$.SCHEMA(), "name"})));
        return var1_1;
    }

    public CsvTableSource createTableSource(boolean isStreaming, Map<String, String> properties) {
        DescriptorProperties params = new DescriptorProperties();
        params.putProperties(properties);
        new FileSystemValidator().validate(params);
        new OldCsvValidator().validate(params);
        new SchemaValidator(isStreaming, false, false).validate(params);
        CsvTableSource.Builder csvTableSourceBuilder = new CsvTableSource.Builder();
        TableSchema formatSchema = params.getTableSchema(OldCsvValidator$.MODULE$.FORMAT_FIELDS());
        TableSchema tableSchema2 = params.getTableSchema(SchemaValidator$.MODULE$.SCHEMA());
        if (formatSchema.equals((Object)tableSchema2)) {
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(FileSystemValidator$.MODULE$.CONNECTOR_PATH())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String path) {
                    return this.csvTableSourceBuilder$1.path(path);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(OldCsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String delim) {
                    return this.csvTableSourceBuilder$1.fieldDelimiter(delim);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(OldCsvValidator$.MODULE$.FORMAT_LINE_DELIMITER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String delim) {
                    return this.csvTableSourceBuilder$1.lineDelimiter(delim);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])formatSchema.getFieldNames()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])formatSchema.getFieldTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(Tuple2<String, TypeInformation<?>> x0$1) {
                    Tuple2<String, TypeInformation<?>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        TypeInformation tpe = (TypeInformation)tuple2._2();
                        CsvTableSource.Builder builder = this.csvTableSourceBuilder$1.field(name, tpe);
                        return builder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalCharacter(OldCsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(Character quote) {
                    return this.csvTableSourceBuilder$1.quoteCharacter(quote);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(OldCsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String prefix) {
                    return this.csvTableSourceBuilder$1.commentPrefix(prefix);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalBoolean(OldCsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final Object apply(Boolean flag) {
                    return Predef$.MODULE$.Boolean2boolean(flag) ? this.csvTableSourceBuilder$1.ignoreFirstLine() : BoxedUnit.UNIT;
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalBoolean(OldCsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final Object apply(Boolean flag) {
                    return Predef$.MODULE$.Boolean2boolean(flag) ? this.csvTableSourceBuilder$1.ignoreParseErrors() : BoxedUnit.UNIT;
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            return csvTableSourceBuilder.build();
        }
        throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSources.");
    }
}

