/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.wikiedits;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.wikiedits.WikipediaEditEvent;
import org.apache.flink.streaming.connectors.wikiedits.WikipediaEditEventIrcStream;

public class WikipediaEditsSource
extends RichSourceFunction<WikipediaEditEvent> {
    public static final String DEFAULT_HOST = "irc.wikimedia.org";
    public static final int DEFAULT_PORT = 6667;
    public static final String DEFAULT_CHANNEL = "#en.wikipedia";
    private final String host;
    private final int port;
    private final String channel;
    private volatile boolean isRunning = true;

    public WikipediaEditsSource() {
        this(DEFAULT_HOST, 6667, DEFAULT_CHANNEL);
    }

    public WikipediaEditsSource(String host, int port, String channel) {
        this.host = host;
        this.port = port;
        this.channel = Objects.requireNonNull(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SourceFunction.SourceContext<WikipediaEditEvent> ctx) throws Exception {
        try (WikipediaEditEventIrcStream ircStream = new WikipediaEditEventIrcStream(this.host, this.port);){
            ircStream.connect();
            ircStream.join(this.channel);
            try {
                while (this.isRunning) {
                    WikipediaEditEvent edit = ircStream.getEdits().poll(100L, TimeUnit.MILLISECONDS);
                    if (edit == null) continue;
                    ctx.collect((Object)edit);
                }
            }
            finally {
                ircStream.leave(this.channel);
            }
        }
    }

    public void cancel() {
        this.isRunning = false;
    }
}

