/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.wikiedits;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikipediaEditEvent {
    private final long timestamp;
    private final String channel;
    private final String title;
    private final String diffUrl;
    private final String user;
    private final int byteDiff;
    private final String summary;
    private final int flags;
    private static final byte IS_MINOR = 1;
    private static final byte IS_NEW = 2;
    private static final byte IS_UNPATROLLED = 4;
    private static final byte IS_BOT_EDIT = 8;
    private static final byte IS_SPECIAL = 16;
    private static final byte IS_TALK = 32;
    private static final Pattern p = Pattern.compile("\\[\\[(.*)\\]\\]\\s(.*)\\s(.*)\\s\\*\\s(.*)\\s\\*\\s\\(\\+?(.\\d*)\\)\\s(.*)");

    public WikipediaEditEvent(long timestamp, String channel, String title, String diffUrl, String user, int byteDiff, String summary, boolean isMinor, boolean isNew, boolean isUnpatrolled, boolean isBotEdit, boolean isSpecial, boolean isTalk) {
        if (channel == null || title == null || diffUrl == null || user == null || summary == null) {
            throw new NullPointerException();
        }
        this.timestamp = timestamp;
        this.channel = channel;
        this.title = title;
        this.diffUrl = diffUrl;
        this.user = user;
        this.byteDiff = byteDiff;
        this.summary = summary;
        this.flags = this.getFlags(isMinor, isNew, isUnpatrolled, isBotEdit, isSpecial, isTalk);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDiffUrl() {
        return this.diffUrl;
    }

    public String getUser() {
        return this.user;
    }

    public int getByteDiff() {
        return this.byteDiff;
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean isMinor() {
        return (this.flags & 1) > 0;
    }

    public boolean isNew() {
        return (this.flags & 2) > 0;
    }

    public boolean isUnpatrolled() {
        return (this.flags & 4) > 0;
    }

    public boolean isBotEdit() {
        return (this.flags & 8) > 0;
    }

    public boolean isSpecial() {
        return (this.flags & 0x10) > 0;
    }

    public boolean isTalk() {
        return (this.flags & 0x20) > 0;
    }

    public String toString() {
        return "WikipediaEditEvent{timestamp=" + this.timestamp + ", channel='" + this.channel + '\'' + ", title='" + this.title + '\'' + ", diffUrl='" + this.diffUrl + '\'' + ", user='" + this.user + '\'' + ", byteDiff=" + this.byteDiff + ", summary='" + this.summary + '\'' + ", flags=" + this.flags + '}';
    }

    private byte getFlags(boolean isMinor, boolean isNew, boolean isUnpatrolled, boolean isBotEdit, boolean isSpecial, boolean isTalk) {
        byte flag = 0;
        flag = (byte)(flag | (isMinor ? (byte)1 : flag));
        flag = (byte)(flag | (isNew ? 2 : (int)flag));
        flag = (byte)(flag | (isUnpatrolled ? 4 : (int)flag));
        flag = (byte)(flag | (isBotEdit ? 8 : (int)flag));
        flag = (byte)(flag | (isSpecial ? 16 : (int)flag));
        flag = (byte)(flag | (isTalk ? 32 : (int)flag));
        return flag;
    }

    public static WikipediaEditEvent fromRawEvent(long timestamp, String channel, String rawEvent) {
        Matcher m = p.matcher(rawEvent);
        if (m.find() && m.groupCount() == 6) {
            String title = m.group(1);
            String flags = m.group(2);
            String diffUrl = m.group(3);
            String user = m.group(4);
            int byteDiff = Integer.parseInt(m.group(5));
            String summary = m.group(6);
            boolean isMinor = flags.contains("M");
            boolean isNew = flags.contains("N");
            boolean isUnpatrolled = flags.contains("!");
            boolean isBotEdit = flags.contains("B");
            boolean isSpecial = title.startsWith("Special:");
            boolean isTalk = title.startsWith("Talk:");
            return new WikipediaEditEvent(timestamp, channel, title, diffUrl, user, byteDiff, summary, isMinor, isNew, isUnpatrolled, isBotEdit, isSpecial, isTalk);
        }
        return null;
    }
}

