/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public class SharedBufferEdge {
    private final NodeId target;
    private final DeweyNumber deweyNumber;

    public SharedBufferEdge(NodeId target, DeweyNumber deweyNumber) {
        this.target = target;
        this.deweyNumber = deweyNumber;
    }

    NodeId getTarget() {
        return this.target;
    }

    DeweyNumber getDeweyNumber() {
        return this.deweyNumber;
    }

    public String toString() {
        return "SharedBufferEdge{target=" + this.target + ", deweyNumber=" + this.deweyNumber + '}';
    }

    public static class SharedBufferEdgeSerializer
    extends TypeSerializerSingleton<SharedBufferEdge> {
        private static final long serialVersionUID = -5122474955050663979L;
        private TypeSerializer<NodeId> nodeIdSerializer;
        private TypeSerializer<DeweyNumber> deweyNumberSerializer;

        public SharedBufferEdgeSerializer() {
            this((TypeSerializer<NodeId>)new NodeId.NodeIdSerializer(), (TypeSerializer<DeweyNumber>)DeweyNumber.DeweyNumberSerializer.INSTANCE);
        }

        private SharedBufferEdgeSerializer(TypeSerializer<NodeId> nodeIdSerializer, TypeSerializer<DeweyNumber> deweyNumberSerializer) {
            this.nodeIdSerializer = (TypeSerializer)Preconditions.checkNotNull(nodeIdSerializer);
            this.deweyNumberSerializer = (TypeSerializer)Preconditions.checkNotNull(deweyNumberSerializer);
        }

        public boolean isImmutableType() {
            return true;
        }

        public SharedBufferEdge createInstance() {
            return null;
        }

        public SharedBufferEdge copy(SharedBufferEdge from) {
            return new SharedBufferEdge(from.target, from.deweyNumber);
        }

        public SharedBufferEdge copy(SharedBufferEdge from, SharedBufferEdge reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(SharedBufferEdge record, DataOutputView target) throws IOException {
            this.nodeIdSerializer.serialize((Object)record.target, target);
            this.deweyNumberSerializer.serialize((Object)record.deweyNumber, target);
        }

        public SharedBufferEdge deserialize(DataInputView source) throws IOException {
            NodeId target = (NodeId)this.nodeIdSerializer.deserialize(source);
            DeweyNumber deweyNumber = (DeweyNumber)this.deweyNumberSerializer.deserialize(source);
            return new SharedBufferEdge(target, deweyNumber);
        }

        public SharedBufferEdge deserialize(SharedBufferEdge reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.nodeIdSerializer.copy(source, target);
            this.deweyNumberSerializer.copy(source, target);
        }

        public TypeSerializerSnapshot<SharedBufferEdge> snapshotConfiguration() {
            return new SharedBufferEdgeSerializerSnapshot(this);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.nodeIdSerializer == null) {
                this.nodeIdSerializer = new NodeId.NodeIdSerializer();
                this.deweyNumberSerializer = DeweyNumber.DeweyNumberSerializer.INSTANCE;
            }
        }

        public static final class SharedBufferEdgeSerializerSnapshot
        extends CompositeTypeSerializerSnapshot<SharedBufferEdge, SharedBufferEdgeSerializer> {
            private static final int VERSION = 1;

            public SharedBufferEdgeSerializerSnapshot() {
                super(SharedBufferEdgeSerializer.class);
            }

            public SharedBufferEdgeSerializerSnapshot(SharedBufferEdgeSerializer sharedBufferEdgeSerializer) {
                super((TypeSerializer)sharedBufferEdgeSerializer);
            }

            protected int getCurrentOuterSnapshotVersion() {
                return 1;
            }

            protected SharedBufferEdgeSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
                return new SharedBufferEdgeSerializer((TypeSerializer)((NodeId.NodeIdSerializer)nestedSerializers[0]), (TypeSerializer)((DeweyNumber.DeweyNumberSerializer)nestedSerializers[1]));
            }

            protected TypeSerializer<?>[] getNestedSerializers(SharedBufferEdgeSerializer outerSerializer) {
                return new TypeSerializer[]{outerSerializer.nodeIdSerializer, outerSerializer.deweyNumberSerializer};
            }
        }
    }
}

