/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class DeweyNumber
implements Serializable {
    private static final long serialVersionUID = 6170434818252267825L;
    private final int[] deweyNumber;

    public DeweyNumber(int start) {
        this.deweyNumber = new int[]{start};
    }

    public DeweyNumber(DeweyNumber number) {
        this.deweyNumber = Arrays.copyOf(number.deweyNumber, number.deweyNumber.length);
    }

    private DeweyNumber(int[] deweyNumber) {
        this.deweyNumber = deweyNumber;
    }

    public boolean isCompatibleWith(DeweyNumber other) {
        if (this.length() > other.length()) {
            for (int i = 0; i < other.length(); ++i) {
                if (other.deweyNumber[i] == this.deweyNumber[i]) continue;
                return false;
            }
            return true;
        }
        if (this.length() == other.length()) {
            int lastIndex = this.length() - 1;
            for (int i = 0; i < lastIndex; ++i) {
                if (other.deweyNumber[i] == this.deweyNumber[i]) continue;
                return false;
            }
            return this.deweyNumber[lastIndex] >= other.deweyNumber[lastIndex];
        }
        return false;
    }

    public int getRun() {
        return this.deweyNumber[0];
    }

    public int length() {
        return this.deweyNumber.length;
    }

    public DeweyNumber increase() {
        return this.increase(1);
    }

    public DeweyNumber increase(int times) {
        int[] newDeweyNumber = Arrays.copyOf(this.deweyNumber, this.deweyNumber.length);
        int n = this.deweyNumber.length - 1;
        newDeweyNumber[n] = newDeweyNumber[n] + times;
        return new DeweyNumber(newDeweyNumber);
    }

    public DeweyNumber addStage() {
        int[] newDeweyNumber = Arrays.copyOf(this.deweyNumber, this.deweyNumber.length + 1);
        return new DeweyNumber(newDeweyNumber);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DeweyNumber) {
            DeweyNumber other = (DeweyNumber)obj;
            return Arrays.equals(this.deweyNumber, other.deweyNumber);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.deweyNumber);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.length() - 1; ++i) {
            builder.append(this.deweyNumber[i]).append(".");
        }
        if (this.length() > 0) {
            builder.append(this.deweyNumber[this.length() - 1]);
        }
        return builder.toString();
    }

    public static DeweyNumber fromString(String deweyNumberString) {
        String[] splits = deweyNumberString.split("\\.");
        if (splits.length == 0) {
            return new DeweyNumber(Integer.parseInt(deweyNumberString));
        }
        int[] deweyNumber = new int[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            deweyNumber[i] = Integer.parseInt(splits[i]);
        }
        return new DeweyNumber(deweyNumber);
    }

    public static class DeweyNumberSerializer
    extends TypeSerializerSingleton<DeweyNumber> {
        private static final long serialVersionUID = -5086792497034943656L;
        public static final DeweyNumberSerializer INSTANCE = new DeweyNumberSerializer();

        private DeweyNumberSerializer() {
        }

        public boolean isImmutableType() {
            return false;
        }

        public DeweyNumber createInstance() {
            return new DeweyNumber(1);
        }

        public DeweyNumber copy(DeweyNumber from) {
            return new DeweyNumber(from);
        }

        public DeweyNumber copy(DeweyNumber from, DeweyNumber reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(DeweyNumber record, DataOutputView target) throws IOException {
            int size = record.length();
            target.writeInt(size);
            for (int i = 0; i < size; ++i) {
                target.writeInt(record.deweyNumber[i]);
            }
        }

        public DeweyNumber deserialize(DataInputView source) throws IOException {
            int size = source.readInt();
            int[] number = new int[size];
            for (int i = 0; i < size; ++i) {
                number[i] = source.readInt();
            }
            return new DeweyNumber(number);
        }

        public DeweyNumber deserialize(DeweyNumber reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            int size = source.readInt();
            target.writeInt(size);
            for (int i = 0; i < size; ++i) {
                target.writeInt(source.readInt());
            }
        }

        public boolean equals(Object obj) {
            return obj == this || obj.getClass().equals(((Object)((Object)this)).getClass());
        }

        public TypeSerializerSnapshot<DeweyNumber> snapshotConfiguration() {
            return new DeweyNumberSerializerSnapshot();
        }

        public static final class DeweyNumberSerializerSnapshot
        extends SimpleTypeSerializerSnapshot<DeweyNumber> {
            public DeweyNumberSerializerSnapshot() {
                super(() -> INSTANCE);
            }
        }
    }
}

