/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import javax.naming.NamingException;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ChangeOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.codec.search.controls.entryChange.EntryChangeControl;
import org.apache.directory.shared.ldap.codec.search.controls.persistentSearch.PersistentSearchControl;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.message.AbandonListener;
import org.apache.directory.shared.ldap.message.SearchResponseEntryImpl;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.message.internal.InternalAbandonableRequest;
import org.apache.directory.shared.ldap.message.internal.InternalSearchRequest;
import org.apache.directory.shared.ldap.message.internal.InternalSearchResponseEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSearchListener
implements DirectoryListener,
AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentSearchListener.class);
    final LdapSession session;
    final InternalSearchRequest req;
    final PersistentSearchControl control;

    PersistentSearchListener(LdapSession session, InternalSearchRequest req) {
        this.session = session;
        this.req = req;
        req.addAbandonListener((AbandonListener)this);
        this.control = (PersistentSearchControl)req.getControls().get("2.16.840.1.113730.3.4.3");
    }

    public void abandon() throws NamingException {
        this.session.getCoreSession().getDirectoryService().getEventService().removeListener((DirectoryListener)this);
    }

    public void requestAbandoned(InternalAbandonableRequest req) {
        try {
            this.abandon();
        }
        catch (NamingException e) {
            LOG.error(I18n.err((String)I18n.ERR_164, (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void setECResponseControl(InternalSearchResponseEntry response, ChangeOperationContext opContext, ChangeType type) {
        if (this.control.isReturnECs()) {
            EntryChangeControl ecControl = new EntryChangeControl();
            ecControl.setChangeType(type);
            if (opContext.getChangeLogEvent() != null) {
                ecControl.setChangeNumber(opContext.getChangeLogEvent().getRevision());
            }
            if (opContext instanceof RenameOperationContext || opContext instanceof MoveOperationContext) {
                ecControl.setPreviousDn(opContext.getDn());
            }
            response.add((Control)ecControl);
        }
    }

    public void entryAdded(AddOperationContext opContext) {
        if (!this.control.isNotificationEnabled(ChangeType.ADD)) {
            return;
        }
        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(opContext.getDn());
        respEntry.setEntry((Entry)opContext.getEntry());
        this.setECResponseControl((InternalSearchResponseEntry)respEntry, (ChangeOperationContext)opContext, ChangeType.ADD);
        this.session.getIoSession().write((Object)respEntry);
    }

    public void entryDeleted(DeleteOperationContext opContext) {
        if (!this.control.isNotificationEnabled(ChangeType.DELETE)) {
            return;
        }
        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(opContext.getDn());
        respEntry.setEntry((Entry)opContext.getEntry());
        this.setECResponseControl((InternalSearchResponseEntry)respEntry, (ChangeOperationContext)opContext, ChangeType.DELETE);
        this.session.getIoSession().write((Object)respEntry);
    }

    public void entryModified(ModifyOperationContext opContext) {
        if (!this.control.isNotificationEnabled(ChangeType.MODIFY)) {
            return;
        }
        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(opContext.getDn());
        respEntry.setEntry((Entry)opContext.getAlteredEntry());
        this.setECResponseControl((InternalSearchResponseEntry)respEntry, (ChangeOperationContext)opContext, ChangeType.MODIFY);
        this.session.getIoSession().write((Object)respEntry);
    }

    public void entryMoved(MoveOperationContext opContext) {
        if (!this.control.isNotificationEnabled(ChangeType.MODDN)) {
            return;
        }
        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(opContext.getDn());
        respEntry.setEntry((Entry)opContext.getEntry());
        this.setECResponseControl((InternalSearchResponseEntry)respEntry, (ChangeOperationContext)opContext, ChangeType.MODDN);
        this.session.getIoSession().write((Object)respEntry);
    }

    public void entryMovedAndRenamed(MoveAndRenameOperationContext opContext) {
        this.entryRenamed((RenameOperationContext)opContext);
    }

    public void entryRenamed(RenameOperationContext opContext) {
        if (!this.control.isNotificationEnabled(ChangeType.MODDN)) {
            return;
        }
        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(opContext.getAlteredEntry().getDn());
        respEntry.setEntry((Entry)opContext.getAlteredEntry());
        this.setECResponseControl((InternalSearchResponseEntry)respEntry, (ChangeOperationContext)opContext, ChangeType.MODDN);
        this.session.getIoSession().write((Object)respEntry);
    }
}

