/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationUtils.class);

    public static void doDelete(File wkdir) throws IOException {
        if (wkdir.exists()) {
            try {
                FileUtils.deleteDirectory((File)wkdir);
            }
            catch (IOException e) {
                LOG.error(I18n.err((String)I18n.ERR_115, (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (wkdir.exists()) {
            throw new IOException(I18n.err((String)I18n.ERR_116, (Object[])new Object[]{wkdir}));
        }
    }

    public static void injectEntries(DirectoryService service, String ldif) throws Exception {
        LdifReader reader = new LdifReader();
        List entries = reader.parseLdif(ldif);
        for (LdifEntry entry : entries) {
            if (entry.isChangeAdd()) {
                service.getAdminSession().add((ServerEntry)new DefaultServerEntry(service.getSchemaManager(), entry.getEntry()));
                continue;
            }
            if (entry.isChangeModify()) {
                service.getAdminSession().modify(entry.getDn(), entry.getModificationItems());
                continue;
            }
            String message = I18n.err((String)I18n.ERR_117, (Object[])new Object[]{entry.getChangeType()});
            LOG.error(message);
            throw new NamingException(message);
        }
        reader.close();
    }

    public static LdifEntry getUserAddLdif() throws InvalidNameException, NamingException {
        return IntegrationUtils.getUserAddLdif("uid=akarasulu,ou=users,ou=system", "test".getBytes(), "Alex Karasulu", "Karasulu");
    }

    public static LdapContext getContext(String principalDn, DirectoryService service, String dn) throws Exception {
        if (principalDn == null) {
            principalDn = "";
        }
        DN userDn = new DN(principalDn);
        userDn.normalize(service.getSchemaManager().getNormalizerMapping());
        LdapPrincipal principal = new LdapPrincipal(userDn, AuthenticationLevel.SIMPLE);
        if (dn == null) {
            dn = "";
        }
        CoreSession session = service.getSession(principal);
        ServerLdapContext ctx = new ServerLdapContext(service, session, new DN(dn));
        return ctx;
    }

    public static CoreSession getCoreSession(String principalDn, DirectoryService service, String dn) throws Exception {
        if (principalDn == null) {
            principalDn = "";
        }
        DN userDn = new DN(principalDn);
        userDn.normalize(service.getSchemaManager().getNormalizerMapping());
        LdapPrincipal principal = new LdapPrincipal(userDn, AuthenticationLevel.SIMPLE);
        if (dn == null) {
            dn = "";
        }
        CoreSession session = service.getSession(principal);
        return session;
    }

    public static LdapContext getSystemContext(DirectoryService service) throws Exception {
        return IntegrationUtils.getContext("uid=admin,ou=system", service, "ou=system");
    }

    public static LdapContext getSchemaContext(DirectoryService service) throws Exception {
        return IntegrationUtils.getContext("uid=admin,ou=system", service, "ou=schema");
    }

    public static LdapContext getRootContext(DirectoryService service) throws Exception {
        return IntegrationUtils.getContext("uid=admin,ou=system", service, "");
    }

    public static void apply(DirectoryService service, LdifEntry entry) throws Exception {
        DN dn = new DN((Name)entry.getDn());
        CoreSession session = service.getAdminSession();
        switch (entry.getChangeType().getChangeType()) {
            case 0: {
                session.add((ServerEntry)new DefaultServerEntry(service.getSchemaManager(), entry.getEntry()));
                break;
            }
            case 4: {
                session.delete(dn);
                break;
            }
            case 2: 
            case 3: {
                RDN newRdn = new RDN(entry.getNewRdn());
                if (entry.getNewSuperior() != null) {
                    RDN oldRdn = dn.getRdn();
                    DN newSuperior = new DN(entry.getNewSuperior());
                    if (dn.size() == 0) {
                        throw new IllegalStateException(I18n.err((String)I18n.ERR_475, (Object[])new Object[0]));
                    }
                    if (oldRdn.equals((Object)newRdn)) {
                        session.move(dn, newSuperior);
                        break;
                    }
                    session.moveAndRename(dn, newSuperior, newRdn, entry.isDeleteOldRdn());
                    break;
                }
                session.rename(dn, newRdn, entry.isDeleteOldRdn());
                break;
            }
            case 1: {
                session.modify(dn, entry.getModificationItems());
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err((String)I18n.ERR_476, (Object[])new Object[]{entry.getChangeType()}));
            }
        }
    }

    public static LdifEntry getUserAddLdif(String dnstr, byte[] password, String cn, String sn) throws InvalidNameException, NamingException {
        DN dn = new DN(dnstr);
        LdifEntry ldif = new LdifEntry();
        ldif.setDn(dnstr);
        ldif.setChangeType(ChangeType.Add);
        DefaultClientAttribute attr = new DefaultClientAttribute("objectClass", new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"});
        ldif.addAttribute((EntryAttribute)attr);
        attr = new DefaultClientAttribute("ou", new String[]{"Engineering", "People"});
        ldif.addAttribute((EntryAttribute)attr);
        String uid = dn.getRdn().getNormValue();
        ldif.putAttribute("uid", (Object)uid);
        ldif.putAttribute("l", (Object)"Bogusville");
        ldif.putAttribute("cn", (Object)cn);
        ldif.putAttribute("sn", (Object)sn);
        ldif.putAttribute("mail", (Object)(uid + "@apache.org"));
        ldif.putAttribute("telephoneNumber", (Object)"+1 408 555 4798");
        ldif.putAttribute("facsimileTelephoneNumber", (Object)"+1 408 555 9751");
        ldif.putAttribute("roomnumber", (Object)"4612");
        ldif.putAttribute("userPassword", (Object)password);
        String givenName = cn.split(" ")[0];
        ldif.putAttribute("givenName", (Object)givenName);
        return ldif;
    }

    public static void enableSchema(DirectoryService service, String schemaName) throws Exception {
        LdapContext schemaRoot = IntegrationUtils.getSchemaContext(service);
        ModificationItem[] mods = new ModificationItem[1];
        BasicAttribute attr = new BasicAttribute("m-disabled", "FALSE");
        mods[0] = new ModificationItem(2, attr);
        schemaRoot.modifyAttributes("cn=" + schemaName, mods);
    }

    public static void disableSchema(DirectoryService service, String schemaName) throws Exception {
        LdapContext schemaRoot = IntegrationUtils.getSchemaContext(service);
        ModificationItem[] mods = new ModificationItem[1];
        BasicAttribute attr = new BasicAttribute("m-disabled", "TRUE");
        mods[0] = new ModificationItem(2, attr);
        schemaRoot.modifyAttributes("cn=" + schemaName, mods);
    }

    public static boolean isDisabled(DirectoryService service, String schemaName) {
        Schema schema = service.getSchemaManager().getLoadedSchema(schemaName);
        return schema == null || schema.isDisabled();
    }

    public static boolean isLoaded(DirectoryService service, String schemaName) {
        Schema schema = service.getSchemaManager().getLoadedSchema(schemaName);
        return schema != null;
    }

    public static boolean isEnabled(DirectoryService service, String schemaName) {
        Schema schema = service.getSchemaManager().getLoadedSchema(schemaName);
        return schema != null && schema.isEnabled();
    }
}

