/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.cloud.ServiceChooser;
import org.apache.camel.cloud.ServiceChooserAware;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryAware;
import org.apache.camel.cloud.ServiceExpressionFactory;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.cloud.ServiceFilterAware;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.impl.cloud.DefaultServiceCallExpression;
import org.apache.camel.impl.cloud.DefaultServiceCallProcessor;
import org.apache.camel.impl.cloud.DefaultServiceLoadBalancer;
import org.apache.camel.impl.cloud.HealthyServiceFilter;
import org.apache.camel.impl.cloud.PassThroughServiceFilter;
import org.apache.camel.impl.cloud.RandomServiceChooser;
import org.apache.camel.impl.cloud.RoundRobinServiceChooser;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.cloud.AggregatingServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ChainedServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.DefaultServiceCallServiceLoadBalancerConfiguration;
import org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.EtcdServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.RibbonServiceCallServiceLoadBalancerConfiguration;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.cloud.ServiceCallExpressionConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceLoadBalancerConfiguration;
import org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ZooKeeperServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;

@Metadata(label="eip,routing")
@XmlRootElement(name="serviceCall")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceCallDefinition
extends NoOutputDefinition<ServiceCallDefinition> {
    @XmlAttribute
    @Metadata(required="true")
    private String name;
    @XmlAttribute
    private String uri;
    @XmlAttribute
    @Metadata(defaultValue="http4")
    private String component;
    @XmlAttribute
    private ExchangePattern pattern;
    @XmlAttribute
    private String configurationRef;
    @XmlAttribute
    private String serviceDiscoveryRef;
    @XmlTransient
    private ServiceDiscovery serviceDiscovery;
    @XmlAttribute
    private String serviceFilterRef;
    @XmlTransient
    private ServiceFilter serviceFilter;
    @XmlAttribute
    private String serviceChooserRef;
    @XmlTransient
    private ServiceChooser serviceChooser;
    @XmlAttribute
    private String loadBalancerRef;
    @XmlTransient
    private ServiceLoadBalancer loadBalancer;
    @XmlAttribute
    private String expressionRef;
    @XmlTransient
    private Expression expression;
    @XmlElements(value={@XmlElement(name="cachingServiceDiscovery", type=CachingServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="aggregatingServiceDiscovery", type=AggregatingServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="consulServiceDiscovery", type=ConsulServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="dnsServiceDiscovery", type=DnsServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="etcdServiceDiscovery", type=EtcdServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="kubernetesServiceDiscovery", type=KubernetesServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="staticServiceDiscovery", type=StaticServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="zookeeperServiceDiscovery", type=ZooKeeperServiceCallServiceDiscoveryConfiguration.class)})
    private ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration;
    @XmlElements(value={@XmlElement(name="blacklistServiceFilter", type=BlacklistServiceCallServiceFilterConfiguration.class), @XmlElement(name="chainedServiceFilter", type=ChainedServiceCallServiceFilterConfiguration.class), @XmlElement(name="customServiceFilter", type=CustomServiceCallServiceFilterConfiguration.class), @XmlElement(name="healthyServiceFilter", type=HealthyServiceCallServiceFilterConfiguration.class), @XmlElement(name="passThroughServiceFilter", type=PassThroughServiceCallServiceFilterConfiguration.class)})
    private ServiceCallServiceFilterConfiguration serviceFilterConfiguration;
    @XmlElements(value={@XmlElement(name="ribbonLoadBalancer", type=RibbonServiceCallServiceLoadBalancerConfiguration.class), @XmlElement(name="defaultLoadBalancer", type=DefaultServiceCallServiceLoadBalancerConfiguration.class)})
    private ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration;
    @XmlElements(value={@XmlElement(name="expressionConfiguration", type=ServiceCallExpressionConfiguration.class)})
    private ServiceCallExpressionConfiguration expressionConfiguration;

    public String toString() {
        return "ServiceCall[" + this.name + "]";
    }

    @Override
    public String getLabel() {
        return "serviceCall";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public String getConfigurationRef() {
        return this.configurationRef;
    }

    public void setConfigurationRef(String configurationRef) {
        this.configurationRef = configurationRef;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getServiceDiscoveryRef() {
        return this.serviceDiscoveryRef;
    }

    public void setServiceDiscoveryRef(String serviceDiscoveryRef) {
        this.serviceDiscoveryRef = serviceDiscoveryRef;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public String getServiceFilterRef() {
        return this.serviceFilterRef;
    }

    public void setServiceFilterRef(String serviceFilterRef) {
        this.serviceFilterRef = serviceFilterRef;
    }

    public ServiceFilter getServiceFilter() {
        return this.serviceFilter;
    }

    public void setServiceFilter(ServiceFilter serviceFilter) {
        this.serviceFilter = serviceFilter;
    }

    public String getServiceChooserRef() {
        return this.serviceChooserRef;
    }

    public void setServiceChooserRef(String serviceChooserRef) {
        this.serviceChooserRef = serviceChooserRef;
    }

    public ServiceChooser getServiceChooser() {
        return this.serviceChooser;
    }

    public void setServiceChooser(ServiceChooser serviceChooser) {
        this.serviceChooser = serviceChooser;
    }

    public String getLoadBalancerRef() {
        return this.loadBalancerRef;
    }

    public void setLoadBalancerRef(String loadBalancerRef) {
        this.loadBalancerRef = loadBalancerRef;
    }

    public ServiceLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(ServiceLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public String getExpressionRef() {
        return this.expressionRef;
    }

    public void setExpressionRef(String expressionRef) {
        this.expressionRef = expressionRef;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ServiceCallServiceDiscoveryConfiguration getServiceDiscoveryConfiguration() {
        return this.serviceDiscoveryConfiguration;
    }

    public void setServiceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.serviceDiscoveryConfiguration = serviceDiscoveryConfiguration;
    }

    public ServiceCallServiceFilterConfiguration getServiceFilterConfiguration() {
        return this.serviceFilterConfiguration;
    }

    public void setServiceFilterConfiguration(ServiceCallServiceFilterConfiguration serviceFilterConfiguration) {
        this.serviceFilterConfiguration = serviceFilterConfiguration;
    }

    public ServiceCallServiceLoadBalancerConfiguration getLoadBalancerConfiguration() {
        return this.loadBalancerConfiguration;
    }

    public void setLoadBalancerConfiguration(ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration) {
        this.loadBalancerConfiguration = loadBalancerConfiguration;
    }

    public ServiceCallExpressionConfiguration getExpressionConfiguration() {
        return this.expressionConfiguration;
    }

    public void setExpressionConfiguration(ServiceCallExpressionConfiguration expressionConfiguration) {
        this.expressionConfiguration = expressionConfiguration;
    }

    public ServiceCallDefinition pattern(ExchangePattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    public ServiceCallDefinition name(String name) {
        this.setName(name);
        return this;
    }

    public ServiceCallDefinition uri(String uri) {
        this.setUri(uri);
        return this;
    }

    public ServiceCallDefinition component(String component) {
        this.setComponent(component);
        return this;
    }

    public ServiceCallDefinition serviceCallConfiguration(String ref) {
        this.configurationRef = ref;
        return this;
    }

    public ServiceCallDefinition serviceDiscovery(String serviceDiscoveryRef) {
        this.setServiceDiscoveryRef(serviceDiscoveryRef);
        return this;
    }

    public ServiceCallDefinition serviceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.setServiceDiscovery(serviceDiscovery);
        return this;
    }

    public ServiceCallDefinition serviceFilter(String serviceFilterRef) {
        this.setServiceDiscoveryRef(this.serviceDiscoveryRef);
        return this;
    }

    public ServiceCallDefinition serviceFilter(ServiceFilter serviceFilter) {
        this.setServiceFilter(serviceFilter);
        return this;
    }

    public ServiceCallDefinition serviceChooser(String serviceChooserRef) {
        this.setServiceChooserRef(serviceChooserRef);
        return this;
    }

    public ServiceCallDefinition serviceChooser(ServiceChooser serviceChooser) {
        this.setServiceChooser(serviceChooser);
        return this;
    }

    public ServiceCallDefinition loadBalancer(String loadBalancerRef) {
        this.setLoadBalancerRef(loadBalancerRef);
        return this;
    }

    public ServiceCallDefinition loadBalancer(ServiceLoadBalancer loadBalancer) {
        this.setLoadBalancer(loadBalancer);
        return this;
    }

    public ServiceCallDefinition expression(String expressionRef) {
        this.setExpressionRef(this.loadBalancerRef);
        return this;
    }

    public ServiceCallDefinition expression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public ExpressionClause<ServiceCallDefinition> expression() {
        ExpressionClause<ServiceCallDefinition> clause = new ExpressionClause<ServiceCallDefinition>(this);
        this.setExpression(clause);
        return clause;
    }

    public ServiceCallDefinition serviceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.setServiceDiscoveryConfiguration(serviceDiscoveryConfiguration);
        return this;
    }

    public ServiceCallDefinition serviceFilterConfiguration(ServiceCallServiceFilterConfiguration serviceFilterConfiguration) {
        this.setServiceFilterConfiguration(serviceFilterConfiguration);
        return this;
    }

    public ServiceCallDefinition loadBalancerConfiguration(ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration) {
        this.setLoadBalancerConfiguration(loadBalancerConfiguration);
        return this;
    }

    public ServiceCallDefinition expressionConfiguration(ServiceCallExpressionConfiguration expressionConfiguration) {
        this.setExpressionConfiguration(expressionConfiguration);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration cachingServiceDiscovery() {
        CachingServiceCallServiceDiscoveryConfiguration conf = new CachingServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ConsulServiceCallServiceDiscoveryConfiguration consulServiceDiscovery() {
        ConsulServiceCallServiceDiscoveryConfiguration conf = new ConsulServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition consulServiceDiscovery(String url) {
        ConsulServiceCallServiceDiscoveryConfiguration conf = new ConsulServiceCallServiceDiscoveryConfiguration(this);
        conf.setUrl(url);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public DnsServiceCallServiceDiscoveryConfiguration dnsServiceDiscovery() {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition dnsServiceDiscovery(String domain) {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration(this);
        conf.setDomain(domain);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition dnsServiceDiscovery(String domain, String protocol) {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration(this);
        conf.setDomain(domain);
        conf.setProto(protocol);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public EtcdServiceCallServiceDiscoveryConfiguration etcdServiceDiscovery() {
        EtcdServiceCallServiceDiscoveryConfiguration conf = new EtcdServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition etcdServiceDiscovery(String uris) {
        EtcdServiceCallServiceDiscoveryConfiguration conf = new EtcdServiceCallServiceDiscoveryConfiguration(this);
        conf.setUris(uris);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition etcdServiceDiscovery(String uris, String servicePath) {
        EtcdServiceCallServiceDiscoveryConfiguration conf = new EtcdServiceCallServiceDiscoveryConfiguration(this);
        conf.setUris(uris);
        conf.setServicePath(servicePath);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesClientServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration(this);
        conf.setLookup("client");
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition kubernetesEnvServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration(this);
        conf.setLookup("environment");
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition kubernetesDnsServiceDiscovery(String namespace, String domain) {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration(this);
        conf.setLookup("dns");
        conf.setNamespace(namespace);
        conf.setDnsDomain(domain);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public AggregatingServiceCallServiceDiscoveryConfiguration multiServiceDiscovery() {
        AggregatingServiceCallServiceDiscoveryConfiguration conf = new AggregatingServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public StaticServiceCallServiceDiscoveryConfiguration staticServiceDiscovery() {
        StaticServiceCallServiceDiscoveryConfiguration conf = new StaticServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ZooKeeperServiceCallServiceDiscoveryConfiguration zookeeperServiceDiscovery() {
        ZooKeeperServiceCallServiceDiscoveryConfiguration conf = new ZooKeeperServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition zookeeperServiceDiscovery(String nodes, String basePath) {
        ZooKeeperServiceCallServiceDiscoveryConfiguration conf = new ZooKeeperServiceCallServiceDiscoveryConfiguration(this);
        conf.setNodes(nodes);
        conf.setBasePath(basePath);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition healthyFilter() {
        HealthyServiceCallServiceFilterConfiguration conf = new HealthyServiceCallServiceFilterConfiguration(this);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition passThroughFilter() {
        PassThroughServiceCallServiceFilterConfiguration conf = new PassThroughServiceCallServiceFilterConfiguration(this);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ChainedServiceCallServiceFilterConfiguration multiFilter() {
        ChainedServiceCallServiceFilterConfiguration conf = new ChainedServiceCallServiceFilterConfiguration(this);
        this.setServiceFilterConfiguration(conf);
        return conf;
    }

    public BlacklistServiceCallServiceFilterConfiguration blacklistFilter() {
        BlacklistServiceCallServiceFilterConfiguration conf = new BlacklistServiceCallServiceFilterConfiguration();
        this.setServiceFilterConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition customFilter(String serviceFilter) {
        CustomServiceCallServiceFilterConfiguration conf = new CustomServiceCallServiceFilterConfiguration();
        conf.setServiceFilterRef(serviceFilter);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition customFilter(ServiceFilter serviceFilter) {
        CustomServiceCallServiceFilterConfiguration conf = new CustomServiceCallServiceFilterConfiguration();
        conf.setServiceFilter(serviceFilter);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition defaultLoadBalancer() {
        DefaultServiceCallServiceLoadBalancerConfiguration conf = new DefaultServiceCallServiceLoadBalancerConfiguration();
        this.setLoadBalancerConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition ribbonLoadBalancer() {
        RibbonServiceCallServiceLoadBalancerConfiguration conf = new RibbonServiceCallServiceLoadBalancerConfiguration(this);
        this.setLoadBalancerConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition ribbonLoadBalancer(String clientName) {
        RibbonServiceCallServiceLoadBalancerConfiguration conf = new RibbonServiceCallServiceLoadBalancerConfiguration(this);
        conf.setClientName(clientName);
        this.setLoadBalancerConfiguration(conf);
        return this;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ServiceCallConfigurationDefinition conf;
        String endpointUri;
        ServiceCallConfigurationDefinition conf2;
        String endpointScheme;
        CamelContext camelContext = routeContext.getCamelContext();
        ServiceDiscovery serviceDiscovery = this.retrieveServiceDiscovery(camelContext);
        ServiceFilter serviceFilter = this.retrieveServiceFilter(camelContext);
        ServiceChooser serviceChooser = this.retrieveServiceChooser(camelContext);
        ServiceLoadBalancer loadBalancer = this.retrieveLoadBalancer(camelContext);
        ObjectHelper.trySetCamelContext(serviceDiscovery, camelContext);
        ObjectHelper.trySetCamelContext(serviceFilter, camelContext);
        ObjectHelper.trySetCamelContext(serviceChooser, camelContext);
        ObjectHelper.trySetCamelContext(loadBalancer, camelContext);
        if (loadBalancer instanceof ServiceDiscoveryAware) {
            ((ServiceDiscoveryAware)((Object)loadBalancer)).setServiceDiscovery(serviceDiscovery);
        }
        if (loadBalancer instanceof ServiceFilterAware) {
            ((ServiceFilterAware)((Object)loadBalancer)).setServiceFilter(serviceFilter);
        }
        if (loadBalancer instanceof ServiceChooserAware) {
            ((ServiceChooserAware)((Object)loadBalancer)).setServiceChooser(serviceChooser);
        }
        if ((endpointScheme = this.component) == null && (conf2 = this.retrieveConfig(camelContext)) != null) {
            endpointScheme = conf2.getComponent();
        }
        if (endpointScheme == null && (conf2 = this.retrieveDefaultConfig(camelContext)) != null) {
            endpointScheme = conf2.getComponent();
        }
        if ((endpointUri = this.uri) == null && (conf = this.retrieveConfig(camelContext)) != null) {
            endpointUri = conf.getUri();
        }
        if (endpointUri == null && (conf = this.retrieveDefaultConfig(camelContext)) != null) {
            endpointUri = conf.getUri();
        }
        ObjectHelper.notNull(this.name, "Service name");
        endpointScheme = ObjectHelper.applyIfNotEmpty(endpointScheme, camelContext::resolvePropertyPlaceholders, () -> "http4");
        endpointUri = ObjectHelper.applyIfNotEmpty(endpointUri, camelContext::resolvePropertyPlaceholders, () -> null);
        return new DefaultServiceCallProcessor(camelContext, camelContext.resolvePropertyPlaceholders(this.name), endpointScheme, endpointUri, this.pattern, loadBalancer, this.retrieveExpression(camelContext, endpointScheme));
    }

    private ServiceCallConfigurationDefinition retrieveDefaultConfig(CamelContext camelContext) {
        ServiceCallConfigurationDefinition config = camelContext.getServiceCallConfiguration(null);
        if (config == null) {
            config = CamelContextHelper.lookup(camelContext, "service-call-configuration", ServiceCallConfigurationDefinition.class);
        }
        if (config == null) {
            config = CamelContextHelper.findByType(camelContext, ServiceCallConfigurationDefinition.class);
        }
        return config;
    }

    private ServiceCallConfigurationDefinition retrieveConfig(CamelContext camelContext) {
        ServiceCallConfigurationDefinition config = null;
        if (this.configurationRef != null && (config = CamelContextHelper.lookup(camelContext, this.configurationRef, ServiceCallConfigurationDefinition.class)) == null) {
            config = camelContext.getServiceCallConfiguration(this.configurationRef);
        }
        return config;
    }

    private ServiceDiscovery retrieveServiceDiscovery(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceDiscovery answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getServiceDiscoveryConfiguration() != null ? config.getServiceDiscoveryConfiguration().newInstance(camelContext) : this.retrieve(ServiceDiscovery.class, camelContext, config::getServiceDiscovery, config::getServiceDiscoveryRef);
        }
        return answer;
    }

    private ServiceDiscovery retrieveServiceDiscovery(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull(() -> this.serviceDiscoveryConfiguration != null ? this.serviceDiscoveryConfiguration.newInstance(camelContext) : null, () -> this.retrieve(ServiceDiscovery.class, camelContext, this::getServiceDiscovery, this::getServiceDiscoveryRef), () -> this.retrieveServiceDiscovery(camelContext, this::retrieveConfig), () -> this.retrieveServiceDiscovery(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.findByType(camelContext, ServiceDiscovery.class), () -> CamelContextHelper.lookup(camelContext, "service-discovery", ServiceDiscovery.class)).orElseGet(() -> null);
    }

    private ServiceFilter retrieveServiceFilter(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceFilter answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null && (answer = config.getServiceFilterConfiguration() != null ? config.getServiceFilterConfiguration().newInstance(camelContext) : this.retrieve(ServiceFilter.class, camelContext, config::getServiceFilter, config::getServiceFilterRef)) == null) {
            String ref = config.getServiceFilterRef();
            if (ObjectHelper.equal("healthy", ref, true)) {
                answer = new HealthyServiceFilter();
            } else if (ObjectHelper.equal("pass-through", ref, true)) {
                answer = new PassThroughServiceFilter();
            } else if (ObjectHelper.equal("passthrough", ref, true)) {
                answer = new PassThroughServiceFilter();
            }
        }
        return answer;
    }

    private ServiceFilter retrieveServiceFilter(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull(() -> this.serviceFilterConfiguration != null ? this.serviceFilterConfiguration.newInstance(camelContext) : null, () -> this.retrieve(ServiceFilter.class, camelContext, this::getServiceFilter, this::getServiceFilterRef), () -> this.retrieveServiceFilter(camelContext, this::retrieveConfig), () -> this.retrieveServiceFilter(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.findByType(camelContext, ServiceFilter.class), () -> CamelContextHelper.lookup(camelContext, "service-filter", ServiceFilter.class)).orElseGet(() -> new HealthyServiceFilter());
    }

    private ServiceChooser retrieveServiceChooser(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceChooser answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = this.retrieve(ServiceChooser.class, camelContext, config::getServiceChooser, config::getServiceChooserRef);
            if (answer == null) {
                String ref = config.getServiceChooserRef();
                if (ObjectHelper.equal("roundrobin", ref, true)) {
                    answer = new RoundRobinServiceChooser();
                } else if (ObjectHelper.equal("round-robin", ref, true)) {
                    answer = new RoundRobinServiceChooser();
                } else if (ObjectHelper.equal("random", ref, true)) {
                    answer = new RandomServiceChooser();
                }
            }
        }
        return answer;
    }

    private ServiceChooser retrieveServiceChooser(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull(() -> this.retrieve(ServiceChooser.class, camelContext, this::getServiceChooser, this::getServiceChooserRef), () -> this.retrieveServiceChooser(camelContext, this::retrieveConfig), () -> this.retrieveServiceChooser(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.findByType(camelContext, ServiceChooser.class), () -> CamelContextHelper.lookup(camelContext, "service-chooser", ServiceChooser.class)).orElseGet(() -> new RoundRobinServiceChooser());
    }

    private ServiceLoadBalancer retrieveLoadBalancer(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceLoadBalancer answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getLoadBalancerConfiguration() != null ? config.getLoadBalancerConfiguration().newInstance(camelContext) : this.retrieve(ServiceLoadBalancer.class, camelContext, config::getLoadBalancer, config::getLoadBalancerRef);
        }
        return answer;
    }

    private ServiceLoadBalancer retrieveLoadBalancer(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull(() -> this.loadBalancerConfiguration != null ? this.loadBalancerConfiguration.newInstance(camelContext) : null, () -> this.retrieve(ServiceLoadBalancer.class, camelContext, this::getLoadBalancer, this::getLoadBalancerRef), () -> this.retrieveLoadBalancer(camelContext, this::retrieveConfig), () -> this.retrieveLoadBalancer(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.findByType(camelContext, ServiceLoadBalancer.class), () -> CamelContextHelper.lookup(camelContext, "load-balancer", ServiceLoadBalancer.class)).orElseGet(() -> new DefaultServiceLoadBalancer());
    }

    private Expression retrieveExpression(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        Expression answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getExpressionConfiguration() != null ? config.getExpressionConfiguration().newInstance(camelContext) : this.retrieve(Expression.class, camelContext, config::getExpression, config::getExpressionRef);
        }
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression retrieveExpression(CamelContext camelContext, String component) throws Exception {
        Optional expression = Suppliers.firstNotNull(() -> this.expressionConfiguration != null ? this.expressionConfiguration.newInstance(camelContext) : null, () -> this.retrieve(Expression.class, camelContext, this::getExpression, this::getExpressionRef), () -> this.retrieveExpression(camelContext, this::retrieveConfig), () -> this.retrieveExpression(camelContext, this::retrieveDefaultConfig), () -> CamelContextHelper.lookup(camelContext, "service-call-expression", Expression.class));
        if (expression.isPresent()) {
            return (Expression)expression.get();
        }
        String lookupName = component + "-service-expression";
        ServiceExpressionFactory factory = CamelContextHelper.lookup(camelContext, lookupName, ServiceExpressionFactory.class);
        if (factory != null) {
            return (Expression)factory.newInstance(camelContext);
        }
        Class<?> type = null;
        try {
            type = camelContext.getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(lookupName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ObjectHelper.isNotEmpty(type)) {
            if (!ServiceExpressionFactory.class.isAssignableFrom(type)) throw new IllegalArgumentException("Resolving Expression: " + lookupName + " detected type conflict: Not a ServiceExpressionFactory implementation. Found: " + type.getName());
            factory = (ServiceExpressionFactory)camelContext.getInjector().newInstance(type);
            return (Expression)factory.newInstance(camelContext);
        } else {
            factory = context -> new DefaultServiceCallExpression();
        }
        return (Expression)factory.newInstance(camelContext);
    }

    private <T> T retrieve(Class<T> type, CamelContext camelContext, Supplier<T> instanceSupplier, Supplier<String> refSupplier) {
        String ref;
        T answer = null;
        if (instanceSupplier != null) {
            answer = instanceSupplier.get();
        }
        if (answer == null && refSupplier != null && (ref = refSupplier.get()) != null) {
            answer = CamelContextHelper.lookup(camelContext, ref, type);
        }
        return answer;
    }
}

