/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.ResourceQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceQuery
extends AbstractQuery {
    public static final String PREFIX = "META-INF/services/";
    private final String serviceName;

    public ServiceQuery(String serviceName) {
        this.serviceName = serviceName;
    }

    public ServiceQuery(Class<?> serviceClass) {
        this(serviceClass.getName());
    }

    @Override
    public String getName() {
        return "service/" + this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result cat(URL url) {
        Result result = new Result(new LinkedHashMap<String, Object>());
        try {
            InputStream in = url.openStream();
            try {
                String line;
                int i = 0;
                InputStreamReader ir = new InputStreamReader(in);
                BufferedReader reader = new BufferedReader(ir);
                while ((line = reader.readLine()) != null) {
                    result.put(i + ": " + line, new ClassExistsQuery(line).call());
                    ++i;
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            this.thrown(result, "", e);
        }
        return result;
    }

    @Override
    protected Result newResult() {
        return new Result(new LinkedHashMap<String, Object>());
    }

    @Override
    public void call(Result result, String prefix) {
        List<URL> urls = new ResourceQuery(PREFIX + this.serviceName).findResources(result, prefix);
        if (urls == null) {
            return;
        }
        for (URL url : urls) {
            result.put(prefix + url, this.cat(url));
        }
    }
}

