/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.util.Arrays;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.FieldExistsQuery;
import org.anarres.jdiagnostics.Result;

public class ClassFieldExistsQuery
extends ClassExistsQuery {
    private final String[] fieldNames;

    public ClassFieldExistsQuery(String className, String fieldName0, String ... fieldNames) {
        super(className);
        this.fieldNames = this.array(String.class, fieldName0, fieldNames);
    }

    public String getName() {
        return "classFieldExists/" + this.className + "/" + Arrays.toString(this.fieldNames);
    }

    public void call(Result result, String prefix) {
        Class<?> type = new ClassExistsQuery(this.className).findClass(result, prefix + "class/");
        if (type == null) {
            return;
        }
        for (String fieldName : this.fieldNames) {
            new FieldExistsQuery(type, fieldName).call(result, prefix + "field/" + fieldName + "/");
        }
    }
}

