/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.moshi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import zipkin.internal.moshi.JsonReader;
import zipkin.internal.moshi.JsonWriter;
import zipkin.internal.moshi.Moshi;
import zipkin.internal.okio.Buffer;
import zipkin.internal.okio.BufferedSink;
import zipkin.internal.okio.BufferedSource;

public abstract class JsonAdapter<T> {
    public abstract T fromJson(JsonReader var1) throws IOException;

    public final T fromJson(BufferedSource source) throws IOException {
        return this.fromJson(JsonReader.of(source));
    }

    public final T fromJson(String string) throws IOException {
        return this.fromJson(new Buffer().writeUtf8(string));
    }

    public abstract void toJson(JsonWriter var1, T var2) throws IOException;

    public final void toJson(BufferedSink sink, T value) throws IOException {
        JsonWriter writer = JsonWriter.of(sink);
        this.toJson(writer, value);
    }

    public final String toJson(T value) {
        Buffer buffer = new Buffer();
        try {
            this.toJson(buffer, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.readUtf8();
    }

    public final JsonAdapter<T> nullSafe() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            @Override
            public T fromJson(JsonReader reader) throws IOException {
                if (reader.peek() == JsonReader.Token.NULL) {
                    return reader.nextNull();
                }
                return delegate.fromJson(reader);
            }

            @Override
            public void toJson(JsonWriter writer, T value) throws IOException {
                if (value == null) {
                    writer.nullValue();
                } else {
                    delegate.toJson(writer, value);
                }
            }

            public String toString() {
                return delegate + ".nullSafe()";
            }
        };
    }

    public final JsonAdapter<T> lenient() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T fromJson(JsonReader reader) throws IOException {
                boolean lenient = reader.isLenient();
                reader.setLenient(true);
                try {
                    Object t = delegate.fromJson(reader);
                    return t;
                }
                finally {
                    reader.setLenient(lenient);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toJson(JsonWriter writer, T value) throws IOException {
                boolean lenient = writer.isLenient();
                writer.setLenient(true);
                try {
                    delegate.toJson(writer, value);
                }
                finally {
                    writer.setLenient(lenient);
                }
            }

            public String toString() {
                return delegate + ".lenient()";
            }
        };
    }

    public final JsonAdapter<T> failOnUnknown() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T fromJson(JsonReader reader) throws IOException {
                boolean skipForbidden = reader.failOnUnknown();
                reader.setFailOnUnknown(true);
                try {
                    Object t = delegate.fromJson(reader);
                    return t;
                }
                finally {
                    reader.setFailOnUnknown(skipForbidden);
                }
            }

            @Override
            public void toJson(JsonWriter writer, T value) throws IOException {
                delegate.toJson(writer, value);
            }

            public String toString() {
                return delegate + ".failOnUnknown()";
            }
        };
    }

    public static interface Factory {
        public JsonAdapter<?> create(Type var1, Set<? extends Annotation> var2, Moshi var3);
    }
}

