/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.EOFException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Util;
import zipkin.internal.okio.Buffer;

public final class ThriftCodec
implements Codec {
    static final int STRING_LENGTH_LIMIT = 0x100000;
    static final int CONTAINER_LENGTH_LIMIT = 10000;
    private static int MAX_SKIP_DEPTH = Integer.MAX_VALUE;
    static final byte TYPE_STOP = 0;
    static final byte TYPE_BOOL = 2;
    static final byte TYPE_BYTE = 3;
    static final byte TYPE_DOUBLE = 4;
    static final byte TYPE_I16 = 6;
    static final byte TYPE_I32 = 8;
    static final byte TYPE_I64 = 10;
    static final byte TYPE_STRING = 11;
    static final byte TYPE_STRUCT = 12;
    static final byte TYPE_MAP = 13;
    static final byte TYPE_SET = 14;
    static final byte TYPE_LIST = 15;
    static final ThriftAdapter<Endpoint> ENDPOINT_ADAPTER = new ThriftAdapter<Endpoint>(){
        final Field IPV4 = new Field(8, 1);
        final Field PORT = new Field(6, 2);
        final Field SERVICE_NAME = new Field(11, 3);

        @Override
        public Endpoint read(ByteBuffer bytes) {
            Endpoint.Builder result = Endpoint.builder();
            while (true) {
                Field field = Field.read(bytes);
                if (field.type == 0) break;
                if (field.equals(this.IPV4)) {
                    result.ipv4(bytes.getInt());
                    continue;
                }
                if (field.equals(this.PORT)) {
                    result.port(bytes.getShort());
                    continue;
                }
                if (field.equals(this.SERVICE_NAME)) {
                    result.serviceName(ThriftCodec.readUtf8(bytes));
                    continue;
                }
                ThriftCodec.skip(bytes, field.type);
            }
            return result.build();
        }

        @Override
        public void write(Endpoint value, Buffer buffer) {
            this.IPV4.write(buffer);
            buffer.writeInt(value.ipv4);
            this.PORT.write(buffer);
            buffer.writeShort(value.port == null ? 0 : (int)value.port.shortValue());
            this.SERVICE_NAME.write(buffer);
            ThriftCodec.writeUtf8(buffer, value.serviceName);
            buffer.writeByte(0);
        }
    };
    static final ThriftAdapter<Annotation> ANNOTATION_ADAPTER = new ThriftAdapter<Annotation>(){
        final Field TIMESTAMP = new Field(10, 1);
        final Field VALUE = new Field(11, 2);
        final Field ENDPOINT = new Field(12, 3);

        @Override
        public Annotation read(ByteBuffer bytes) {
            Annotation.Builder result = Annotation.builder();
            while (true) {
                Field field = Field.read(bytes);
                if (field.type == 0) break;
                if (field.equals(this.TIMESTAMP)) {
                    result.timestamp(bytes.getLong());
                    continue;
                }
                if (field.equals(this.VALUE)) {
                    result.value(ThriftCodec.readUtf8(bytes));
                    continue;
                }
                if (field.equals(this.ENDPOINT)) {
                    result.endpoint((Endpoint)ENDPOINT_ADAPTER.read(bytes));
                    continue;
                }
                ThriftCodec.skip(bytes, field.type);
            }
            return result.build();
        }

        @Override
        public void write(Annotation value, Buffer buffer) {
            this.TIMESTAMP.write(buffer);
            buffer.writeLong(value.timestamp);
            if (value.value != null) {
                this.VALUE.write(buffer);
                ThriftCodec.writeUtf8(buffer, value.value);
            }
            if (value.endpoint != null) {
                this.ENDPOINT.write(buffer);
                ENDPOINT_ADAPTER.write(value.endpoint, buffer);
            }
            buffer.writeByte(0);
        }
    };
    static final ThriftAdapter<BinaryAnnotation> BINARY_ANNOTATION_ADAPTER = new ThriftAdapter<BinaryAnnotation>(){
        final Field KEY = new Field(11, 1);
        final Field VALUE = new Field(11, 2);
        final Field TYPE = new Field(8, 3);
        final Field ENDPOINT = new Field(12, 4);

        @Override
        public BinaryAnnotation read(ByteBuffer bytes) {
            BinaryAnnotation.Builder result = BinaryAnnotation.builder();
            while (true) {
                Field field = Field.read(bytes);
                if (field.type == 0) break;
                if (field.equals(this.KEY)) {
                    result.key(ThriftCodec.readUtf8(bytes));
                    continue;
                }
                if (field.equals(this.VALUE)) {
                    result.value(ThriftCodec.readByteArray(bytes));
                    continue;
                }
                if (field.equals(this.TYPE)) {
                    result.type(BinaryAnnotation.Type.fromValue(bytes.getInt()));
                    continue;
                }
                if (field.equals(this.ENDPOINT)) {
                    result.endpoint((Endpoint)ENDPOINT_ADAPTER.read(bytes));
                    continue;
                }
                ThriftCodec.skip(bytes, field.type);
            }
            return result.build();
        }

        @Override
        public void write(BinaryAnnotation value, Buffer buffer) {
            this.KEY.write(buffer);
            ThriftCodec.writeUtf8(buffer, value.key);
            this.VALUE.write(buffer);
            buffer.writeInt(value.value.length);
            buffer.write(value.value);
            this.TYPE.write(buffer);
            buffer.writeInt(value.type.value);
            if (value.endpoint != null) {
                this.ENDPOINT.write(buffer);
                ENDPOINT_ADAPTER.write(value.endpoint, buffer);
            }
            buffer.writeByte(0);
        }
    };
    static final ThriftAdapter<List<Annotation>> ANNOTATIONS_ADAPTER = new ListAdapter<Annotation>(ANNOTATION_ADAPTER);
    static final ThriftAdapter<List<BinaryAnnotation>> BINARY_ANNOTATIONS_ADAPTER = new ListAdapter<BinaryAnnotation>(BINARY_ANNOTATION_ADAPTER);
    static final ThriftAdapter<Span> SPAN_ADAPTER = new ThriftAdapter<Span>(){
        final Field TRACE_ID = new Field(10, 1);
        final Field NAME = new Field(11, 3);
        final Field ID = new Field(10, 4);
        final Field PARENT_ID = new Field(10, 5);
        final Field ANNOTATIONS = new Field(15, 6);
        final Field BINARY_ANNOTATIONS = new Field(15, 8);
        final Field DEBUG = new Field(2, 9);
        final Field TIMESTAMP = new Field(10, 10);
        final Field DURATION = new Field(10, 11);

        @Override
        public Span read(ByteBuffer bytes) {
            Span.Builder result = Span.builder();
            while (true) {
                Field field = Field.read(bytes);
                if (field.type == 0) break;
                if (field.equals(this.TRACE_ID)) {
                    result.traceId(bytes.getLong());
                    continue;
                }
                if (field.equals(this.NAME)) {
                    result.name(ThriftCodec.readUtf8(bytes));
                    continue;
                }
                if (field.equals(this.ID)) {
                    result.id(bytes.getLong());
                    continue;
                }
                if (field.equals(this.PARENT_ID)) {
                    result.parentId(bytes.getLong());
                    continue;
                }
                if (field.equals(this.ANNOTATIONS)) {
                    result.annotations((Collection)ANNOTATIONS_ADAPTER.read(bytes));
                    continue;
                }
                if (field.equals(this.BINARY_ANNOTATIONS)) {
                    result.binaryAnnotations((Collection)BINARY_ANNOTATIONS_ADAPTER.read(bytes));
                    continue;
                }
                if (field.equals(this.DEBUG)) {
                    result.debug(bytes.get() == 1);
                    continue;
                }
                if (field.equals(this.TIMESTAMP)) {
                    result.timestamp(bytes.getLong());
                    continue;
                }
                if (field.equals(this.DURATION)) {
                    result.duration(bytes.getLong());
                    continue;
                }
                ThriftCodec.skip(bytes, field.type);
            }
            return result.build();
        }

        @Override
        public void write(Span value, Buffer buffer) {
            this.TRACE_ID.write(buffer);
            buffer.writeLong(value.traceId);
            this.NAME.write(buffer);
            ThriftCodec.writeUtf8(buffer, value.name);
            this.ID.write(buffer);
            buffer.writeLong(value.id);
            if (value.parentId != null) {
                this.PARENT_ID.write(buffer);
                buffer.writeLong(value.parentId);
            }
            this.ANNOTATIONS.write(buffer);
            ANNOTATIONS_ADAPTER.write(value.annotations, buffer);
            this.BINARY_ANNOTATIONS.write(buffer);
            BINARY_ANNOTATIONS_ADAPTER.write(value.binaryAnnotations, buffer);
            if (value.debug != null) {
                this.DEBUG.write(buffer);
                buffer.writeByte(value.debug != false ? 1 : 0);
            }
            if (value.timestamp != null) {
                this.TIMESTAMP.write(buffer);
                buffer.writeLong(value.timestamp);
            }
            if (value.duration != null) {
                this.DURATION.write(buffer);
                buffer.writeLong(value.duration);
            }
            buffer.writeByte(0);
        }

        public String toString() {
            return "Span";
        }
    };
    static final ThriftAdapter<List<Span>> SPANS_ADAPTER = new ListAdapter<Span>(SPAN_ADAPTER);
    static final ThriftAdapter<List<List<Span>>> TRACES_ADAPTER = new ListAdapter<List<Span>>(SPANS_ADAPTER);
    static final ThriftAdapter<DependencyLink> DEPENDENCY_LINK_ADAPTER = new ThriftAdapter<DependencyLink>(){
        final Field PARENT = new Field(11, 1);
        final Field CHILD = new Field(11, 2);
        final Field CALL_COUNT = new Field(10, 4);

        @Override
        public DependencyLink read(ByteBuffer bytes) {
            DependencyLink.Builder result = DependencyLink.builder();
            while (true) {
                Field field = Field.read(bytes);
                if (field.type == 0) break;
                if (field.equals(this.PARENT)) {
                    result.parent(ThriftCodec.readUtf8(bytes));
                    continue;
                }
                if (field.equals(this.CHILD)) {
                    result.child(ThriftCodec.readUtf8(bytes));
                    continue;
                }
                if (field.equals(this.CALL_COUNT)) {
                    result.callCount(bytes.getLong());
                    continue;
                }
                ThriftCodec.skip(bytes, field.type);
            }
            return result.build();
        }

        @Override
        public void write(DependencyLink value, Buffer buffer) {
            this.PARENT.write(buffer);
            ThriftCodec.writeUtf8(buffer, value.parent);
            this.CHILD.write(buffer);
            ThriftCodec.writeUtf8(buffer, value.child);
            this.CALL_COUNT.write(buffer);
            buffer.writeLong(value.callCount);
            buffer.writeByte(0);
        }

        public String toString() {
            return "DependencyLink";
        }
    };
    static final ThriftAdapter<List<DependencyLink>> DEPENDENCY_LINKS_ADAPTER = new ListAdapter<DependencyLink>(DEPENDENCY_LINK_ADAPTER);

    public Span readSpan(ByteBuffer bytes) {
        return ThriftCodec.read(SPAN_ADAPTER, bytes);
    }

    @Override
    public Span readSpan(byte[] bytes) {
        return ThriftCodec.read(SPAN_ADAPTER, ByteBuffer.wrap(bytes));
    }

    @Override
    public byte[] writeSpan(Span value) {
        return ThriftCodec.write(SPAN_ADAPTER, value);
    }

    @Override
    public List<Span> readSpans(byte[] bytes) {
        return ThriftCodec.read(SPANS_ADAPTER, ByteBuffer.wrap(bytes));
    }

    @Override
    public byte[] writeSpans(List<Span> value) {
        return ThriftCodec.write(SPANS_ADAPTER, value);
    }

    @Override
    public byte[] writeTraces(List<List<Span>> value) {
        return ThriftCodec.write(TRACES_ADAPTER, value);
    }

    public List<DependencyLink> readDependencyLinks(ByteBuffer bytes) {
        return ThriftCodec.read(DEPENDENCY_LINKS_ADAPTER, bytes);
    }

    @Override
    public List<DependencyLink> readDependencyLinks(byte[] bytes) {
        return ThriftCodec.read(DEPENDENCY_LINKS_ADAPTER, ByteBuffer.wrap(bytes));
    }

    @Override
    public byte[] writeDependencyLinks(List<DependencyLink> value) {
        return ThriftCodec.write(DEPENDENCY_LINKS_ADAPTER, value);
    }

    static <T> T read(ThriftReader<T> reader, ByteBuffer bytes) {
        Util.checkArgument(bytes.remaining() > 0, "Empty input reading %s", reader);
        try {
            return reader.read(bytes);
        }
        catch (RuntimeException e) {
            throw ThriftCodec.exceptionReading(reader.toString(), bytes, e);
        }
    }

    static <T> byte[] write(ThriftWriter<T> writer, T value) {
        Buffer buffer = new Buffer();
        try {
            writer.write(value, buffer);
        }
        catch (RuntimeException e) {
            throw new AssertionError("Could not write " + value + " as TBinary", e);
        }
        return buffer.readByteArray();
    }

    static <T> List<T> readList(ThriftReader<T> reader, ByteBuffer bytes) {
        byte ignoredType = bytes.get();
        int length = ThriftCodec.guardLength(bytes, 10000);
        if (length == 0) {
            return Collections.emptyList();
        }
        if (length == 1) {
            return Collections.singletonList(reader.read(bytes));
        }
        ArrayList<T> result = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            result.add(reader.read(bytes));
        }
        return result;
    }

    static <T> void writeList(ThriftWriter<T> writer, List<T> value, Buffer buffer) {
        int length = value.size();
        ThriftCodec.writeListBegin(buffer, length);
        for (int i = 0; i < length; ++i) {
            writer.write(value.get(i), buffer);
        }
    }

    static IllegalArgumentException exceptionReading(String type, ByteBuffer bytes, Exception e) {
        String cause;
        String string = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (e instanceof EOFException) {
            cause = "EOF";
        }
        if (e instanceof IllegalStateException || e instanceof BufferUnderflowException) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from TBinary: ", cause, type, bytes);
        throw new IllegalArgumentException(message, e);
    }

    static void skip(ByteBuffer bytes, byte type) {
        ThriftCodec.skip(bytes, type, MAX_SKIP_DEPTH);
    }

    static void skip(ByteBuffer bytes, byte type, int maxDepth) {
        if (maxDepth <= 0) {
            throw new IllegalStateException("Maximum skip depth exceeded");
        }
        switch (type) {
            case 2: 
            case 3: {
                ThriftCodec.skip(bytes, 1);
                break;
            }
            case 6: {
                ThriftCodec.skip(bytes, 2);
                break;
            }
            case 8: {
                ThriftCodec.skip(bytes, 4);
                break;
            }
            case 4: 
            case 10: {
                ThriftCodec.skip(bytes, 8);
                break;
            }
            case 11: {
                int size = ThriftCodec.guardLength(bytes, 0x100000);
                ThriftCodec.skip(bytes, size);
                break;
            }
            case 12: {
                while (true) {
                    Field field = Field.read(bytes);
                    if (field.type == 0) {
                        return;
                    }
                    ThriftCodec.skip(bytes, field.type, maxDepth - 1);
                }
            }
            case 13: {
                byte keyType = bytes.get();
                byte valueType = bytes.get();
                int length = ThriftCodec.guardLength(bytes, 10000);
                for (int i = 0; i < length; ++i) {
                    ThriftCodec.skip(bytes, keyType, maxDepth - 1);
                    ThriftCodec.skip(bytes, valueType, maxDepth - 1);
                }
                break;
            }
            case 14: 
            case 15: {
                byte elemType = bytes.get();
                int length = ThriftCodec.guardLength(bytes, 10000);
                for (int i = 0; i < length; ++i) {
                    ThriftCodec.skip(bytes, elemType, maxDepth - 1);
                }
                break;
            }
        }
    }

    static void skip(ByteBuffer bytes, int count) {
        bytes.position(bytes.position() + count);
    }

    static byte[] readByteArray(ByteBuffer bytes) {
        byte[] result = new byte[ThriftCodec.guardLength(bytes, 0x100000)];
        bytes.get(result);
        return result;
    }

    static String readUtf8(ByteBuffer bytes) {
        return new String(ThriftCodec.readByteArray(bytes), Util.UTF_8);
    }

    static int guardLength(ByteBuffer bytes, int limit) {
        int length = bytes.getInt();
        if (length > limit) {
            throw new IllegalStateException(length + " > " + limit + ": possibly malformed thrift");
        }
        return length;
    }

    static void writeListBegin(Buffer buffer, int size) {
        buffer.writeByte(12);
        buffer.writeInt(size);
    }

    static void writeUtf8(Buffer buffer, String string) {
        Buffer temp = new Buffer().writeUtf8(string);
        buffer.writeInt((int)temp.size());
        buffer.write(temp, temp.size());
    }

    static final class Field {
        final byte type;
        final int id;

        Field(byte type, int id) {
            this.type = type;
            this.id = id;
        }

        void write(Buffer buffer) {
            buffer.writeByte(this.type);
            buffer.writeShort(this.id);
        }

        static Field read(ByteBuffer bytes) {
            byte type;
            return new Field(type, (type = bytes.get()) == 0 ? (short)0 : bytes.getShort());
        }

        boolean equals(Field that) {
            return this.type == that.type && this.id == that.id;
        }
    }

    static final class ListAdapter<T>
    implements ThriftAdapter<List<T>> {
        final ThriftAdapter<T> adapter;

        ListAdapter(ThriftAdapter<T> adapter) {
            this.adapter = adapter;
        }

        @Override
        public List<T> read(ByteBuffer bytes) {
            return ThriftCodec.readList(this.adapter, bytes);
        }

        @Override
        public void write(List<T> value, Buffer buffer) {
            ThriftCodec.writeList(this.adapter, value, buffer);
        }

        public String toString() {
            return "List<" + this.adapter + ">";
        }
    }

    static interface ThriftAdapter<T>
    extends ThriftReader<T>,
    ThriftWriter<T> {
    }

    static interface ThriftReader<T> {
        public T read(ByteBuffer var1);
    }

    static interface ThriftWriter<T> {
        public void write(T var1, Buffer var2);
    }
}

