/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.Callback;
import zipkin.CollectorMetrics;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class SpanConsumerLogger {
    private final Logger logger;
    private final CollectorMetrics metrics;

    public SpanConsumerLogger(Class<?> clazz, CollectorMetrics metrics) {
        this.logger = Logger.getLogger(Util.checkNotNull(clazz, "class").getName());
        this.metrics = Util.checkNotNull(metrics, "metrics");
    }

    SpanConsumerLogger(Logger logger, CollectorMetrics metrics) {
        this.logger = Util.checkNotNull(logger, "logger");
        this.metrics = Util.checkNotNull(metrics, "metrics");
    }

    public void acceptedMessage() {
        this.metrics.incrementMessages();
    }

    public void dropMessage() {
        this.metrics.incrementMessagesDropped();
    }

    public void readBytes(int count) {
        this.metrics.incrementBytes(count);
    }

    public void readSpans(int count) {
        this.metrics.incrementSpans(count);
    }

    public String errorReading(Throwable e) {
        return this.errorReading("Cannot decode spans", e);
    }

    public String errorReading(String message, Throwable e) {
        this.metrics.incrementMessagesDropped();
        return this.doError(message, e);
    }

    public String errorAcceptingSpans(List<Span> spans, Throwable e) {
        this.metrics.incrementSpansDropped(spans.size());
        StringBuilder msg = SpanConsumerLogger.appendSpanIds(spans, new StringBuilder("Cannot store traceId -> spanId "));
        return this.doError(msg.toString(), e);
    }

    public Callback<Void> acceptSpansCallback(final List<Span> spans) {
        return new Callback<Void>(){

            @Override
            public void onSuccess(@Nullable Void value) {
            }

            @Override
            public void onError(Throwable t) {
                SpanConsumerLogger.this.errorAcceptingSpans(spans, t);
            }

            public String toString() {
                return SpanConsumerLogger.appendSpanIds(spans, new StringBuilder("AcceptSpans(")).append(")").toString();
            }
        };
    }

    String doError(String message, Throwable e) {
        message = String.format("%s due to %s(%s)", message, e.getClass().getSimpleName(), e.getMessage() == null ? "" : e.getMessage());
        this.logger.log(Level.WARNING, message, e);
        return message;
    }

    static StringBuilder appendSpanIds(List<Span> spans, StringBuilder message) {
        message.append("[");
        Iterator<Span> iterator = spans.iterator();
        while (iterator.hasNext()) {
            Span span = iterator.next();
            message.append(Util.toLowerHex(span.traceId)).append(" -> ").append(Util.toLowerHex(span.id));
            if (!iterator.hasNext()) continue;
            message.append(", ");
        }
        return message.append("]");
    }
}

