/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import zipkin.internal.Nullable;
import zipkin.internal.Util;

public abstract class Lazy<T> {
    private volatile T instance = null;

    public static <T> Lazy<T> of(final T instance) {
        Util.checkNotNull(instance, "instance");
        return new Lazy<T>(){

            @Override
            protected T compute() {
                return instance;
            }

            public String toString() {
                return instance.toString();
            }
        };
    }

    protected abstract T compute();

    @Nullable
    protected final T maybeGet() {
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get() {
        T result = this.instance;
        if (result == null) {
            Lazy lazy = this;
            synchronized (lazy) {
                result = this.instance;
                if (result == null) {
                    this.instance = result = this.compute();
                }
            }
        }
        return result;
    }
}

