/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import zipkin.Callback;
import zipkin.internal.Nullable;

public final class CallbackCaptor<V>
implements Callback<V> {
    final CountDownLatch countDown = new CountDownLatch(1);
    final AtomicReference<Object> ref = new AtomicReference();

    @Nullable
    public V get() {
        boolean interrupted = false;
        while (true) {
            try {
                this.countDown.await();
                Object result = this.ref.get();
                if (result instanceof Throwable) {
                    if (result instanceof Error) {
                        throw (Error)result;
                    }
                    if (result instanceof RuntimeException) {
                        throw (RuntimeException)result;
                    }
                    throw new RuntimeException((Exception)result);
                }
                Object object = result;
                return (V)object;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void onSuccess(@Nullable V value) {
        this.ref.set(value);
        this.countDown.countDown();
    }

    @Override
    public void onError(Throwable t) {
        this.ref.set(t);
        this.countDown.countDown();
    }
}

