/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.util.ArrayList;
import java.util.List;
import zipkin.AsyncSpanConsumer;
import zipkin.Callback;
import zipkin.CollectorMetrics;
import zipkin.CollectorSampler;
import zipkin.Span;
import zipkin.internal.Util;

final class InternalSamplingAsyncSpanConsumer
implements AsyncSpanConsumer {
    final AsyncSpanConsumer asyncConsumer;
    final CollectorSampler sampler;
    final CollectorMetrics metrics;

    InternalSamplingAsyncSpanConsumer(AsyncSpanConsumer asyncConsumer, CollectorSampler sampler, CollectorMetrics metrics) {
        this.asyncConsumer = Util.checkNotNull(asyncConsumer, "asyncConsumer");
        this.sampler = Util.checkNotNull(sampler, "sampler");
        this.metrics = Util.checkNotNull(metrics, "metrics");
    }

    @Override
    public void accept(List<Span> input, Callback<Void> callback) {
        ArrayList<Span> sampled = new ArrayList<Span>(input.size());
        for (Span s : input) {
            if (!this.sampler.isSampled(s)) continue;
            sampled.add(s);
        }
        int dropped = input.size() - sampled.size();
        if (dropped > 0) {
            this.metrics.incrementSpansDropped(dropped);
        }
        this.asyncConsumer.accept(sampled, callback);
    }
}

