/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.util.concurrent.Executor;
import zipkin.AsyncSpanConsumer;
import zipkin.AsyncSpanStore;
import zipkin.CollectorMetrics;
import zipkin.CollectorSampler;
import zipkin.InMemorySpanStore;
import zipkin.StorageAdapters;
import zipkin.StorageComponent;

public final class InMemoryStorage
implements StorageComponent {
    final InMemorySpanStore spanStore = new InMemorySpanStore();
    final Executor callingThread = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    final AsyncSpanStore asyncSpanStore = StorageAdapters.blockingToAsync(this.spanStore, this.callingThread);
    final AsyncSpanConsumer asyncConsumer;

    public InMemoryStorage() {
        this.asyncConsumer = StorageAdapters.blockingToAsync(this.spanStore.spanConsumer, this.callingThread);
    }

    @Override
    public InMemorySpanStore spanStore() {
        return this.spanStore;
    }

    @Override
    public AsyncSpanStore asyncSpanStore() {
        return this.asyncSpanStore;
    }

    public StorageAdapters.SpanConsumer spanConsumer() {
        return this.spanStore.spanConsumer;
    }

    @Override
    public AsyncSpanConsumer asyncSpanConsumer(CollectorSampler sampler, CollectorMetrics metrics) {
        return StorageAdapters.makeSampled(this.asyncConsumer, sampler, metrics);
    }

    public void clear() {
        this.spanStore.clear();
    }

    public int acceptedSpanCount() {
        return this.spanStore.acceptedSpanCount;
    }

    @Override
    public void close() {
    }
}

