/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.DependencyLink;
import zipkin.QueryRequest;
import zipkin.Span;
import zipkin.SpanStore;
import zipkin.StorageAdapters;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.DependencyLinkSpan;
import zipkin.internal.DependencyLinker;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Pair;
import zipkin.internal.Util;

public final class InMemorySpanStore
implements SpanStore {
    private final Multimap<Long, Span> traceIdToSpans = new LinkedListMultimap<Long, Span>();
    private final Set<Pair<Long>> traceIdTimeStamps = new TreeSet<Pair<Long>>(VALUE_2_DESCENDING);
    private final Multimap<String, Pair<Long>> serviceToTraceIdTimeStamp = new SortedByValue2Descending<String>();
    private final Multimap<String, String> serviceToSpanNames = new LinkedHashSetMultimap<String, String>();
    volatile int acceptedSpanCount;
    final StorageAdapters.SpanConsumer spanConsumer = new StorageAdapters.SpanConsumer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(List<Span> spans) {
            for (Span span : spans) {
                span = ApplyTimestampAndDuration.apply(span);
                Pair<Long> traceIdTimeStamp = Pair.create(span.traceId, span.timestamp == null ? Long.MIN_VALUE : span.timestamp);
                String spanName = span.name;
                InMemorySpanStore inMemorySpanStore = InMemorySpanStore.this;
                synchronized (inMemorySpanStore) {
                    InMemorySpanStore.this.traceIdTimeStamps.add(traceIdTimeStamp);
                    InMemorySpanStore.this.traceIdToSpans.put(span.traceId, span);
                    ++InMemorySpanStore.this.acceptedSpanCount;
                    for (String serviceName : span.serviceNames()) {
                        InMemorySpanStore.this.serviceToTraceIdTimeStamp.put(serviceName, traceIdTimeStamp);
                        InMemorySpanStore.this.serviceToSpanNames.put(serviceName, spanName);
                    }
                }
            }
        }

        public String toString() {
            return "InMemorySpanConsumer";
        }
    };
    static final Comparator<List<Span>> TRACE_DESCENDING = new Comparator<List<Span>>(){

        @Override
        public int compare(List<Span> left, List<Span> right) {
            return right.get(0).compareTo(left.get(0));
        }
    };
    static final Comparator<Pair<Long>> VALUE_2_DESCENDING = new Comparator<Pair<Long>>(){

        @Override
        public int compare(Pair<Long> left, Pair<Long> right) {
            int result = ((Long)right._2).compareTo((Long)left._2);
            if (result != 0) {
                return result;
            }
            return ((Long)right._1).compareTo((Long)left._1);
        }
    };

    public synchronized List<Long> traceIds() {
        return Util.sortedList(this.traceIdToSpans.keySet());
    }

    synchronized void clear() {
        this.acceptedSpanCount = 0;
        this.traceIdToSpans.clear();
        this.serviceToTraceIdTimeStamp.clear();
    }

    @Override
    public synchronized List<List<Span>> getTraces(QueryRequest request) {
        Set<Long> traceIds = this.traceIdsDescendingByTimestamp(request.serviceName);
        if (traceIds == null || traceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<Span>> result = new ArrayList<List<Span>>(traceIds.size());
        for (long traceId : traceIds) {
            List<Span> next = this.getTrace(traceId);
            if (next != null && InMemorySpanStore.test(request, next)) {
                result.add(next);
            }
            if (result.size() != request.limit) continue;
            break;
        }
        Collections.sort(result, TRACE_DESCENDING);
        return result;
    }

    Set<Long> traceIdsDescendingByTimestamp(@Nullable String serviceName) {
        Set<Pair<Long>> traceIdTimestamps;
        Collection<Pair<Long>> collection = traceIdTimestamps = serviceName == null ? this.traceIdTimeStamps : this.serviceToTraceIdTimeStamp.get(serviceName);
        if (traceIdTimestamps == null || traceIdTimestamps.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        for (Pair pair : traceIdTimestamps) {
            result.add((Long)pair._1);
        }
        return result;
    }

    @Override
    public synchronized List<Span> getTrace(long traceId) {
        List<Span> spans = this.getRawTrace(traceId);
        return spans == null ? null : CorrectForClockSkew.apply(MergeById.apply(spans));
    }

    @Override
    public synchronized List<Span> getRawTrace(long traceId) {
        List spans = (List)this.traceIdToSpans.get(traceId);
        if (spans == null || spans.isEmpty()) {
            return null;
        }
        return spans;
    }

    @Override
    public synchronized List<String> getServiceNames() {
        return Util.sortedList(this.serviceToTraceIdTimeStamp.keySet());
    }

    @Override
    public synchronized List<String> getSpanNames(String service) {
        if (service == null) {
            return Collections.emptyList();
        }
        service = service.toLowerCase();
        return Util.sortedList(this.serviceToSpanNames.get(service));
    }

    @Override
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        lookback = lookback == null ? Long.valueOf(endTs *= 1000L) : Long.valueOf(lookback * 1000L);
        DependencyLinker linksBuilder = new DependencyLinker();
        for (Collection trace : ((Multimap)this.traceIdToSpans).delegate.values()) {
            if (trace.isEmpty()) continue;
            LinkedList<DependencyLinkSpan> linkSpans = new LinkedList<DependencyLinkSpan>();
            for (Span s : MergeById.apply(trace)) {
                Long timestamp = s.timestamp;
                if (timestamp == null || timestamp < endTs - lookback || timestamp > endTs) continue;
                DependencyLinkSpan.Builder linkSpan = DependencyLinkSpan.builder(s.parentId, s.id);
                for (BinaryAnnotation binaryAnnotation : s.binaryAnnotations) {
                    if (binaryAnnotation.key.equals("ca") && binaryAnnotation.endpoint != null) {
                        linkSpan.caService(binaryAnnotation.endpoint.serviceName);
                        continue;
                    }
                    if (!binaryAnnotation.key.equals("sa") || binaryAnnotation.endpoint == null) continue;
                    linkSpan.saService(binaryAnnotation.endpoint.serviceName);
                }
                for (Annotation annotation : s.annotations) {
                    if (!annotation.value.equals("sr") || annotation.endpoint == null) continue;
                    linkSpan.srService(annotation.endpoint.serviceName);
                    break;
                }
                linkSpans.add(linkSpan.build());
            }
            linksBuilder.putTrace(linkSpans.iterator());
        }
        return linksBuilder.link();
    }

    static boolean test(QueryRequest request, List<Span> spans) {
        Long timestamp = spans.get((int)0).timestamp;
        if (timestamp == null || timestamp < (request.endTs - request.lookback) * 1000L || timestamp > request.endTs * 1000L) {
            return false;
        }
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        boolean testedDuration = request.minDuration == null && request.maxDuration == null;
        String spanName = request.spanName;
        LinkedHashSet<String> annotations = new LinkedHashSet<String>(request.annotations);
        LinkedHashMap<String, String> binaryAnnotations = new LinkedHashMap<String, String>(request.binaryAnnotations);
        LinkedHashSet<String> currentServiceNames = new LinkedHashSet<String>();
        for (Span span : spans) {
            currentServiceNames.clear();
            for (Annotation a : span.annotations) {
                annotations.remove(a.value);
                if (a.endpoint == null) continue;
                serviceNames.add(a.endpoint.serviceName);
                currentServiceNames.add(a.endpoint.serviceName);
            }
            for (BinaryAnnotation b : span.binaryAnnotations) {
                if (b.type == BinaryAnnotation.Type.STRING && new String(b.value, Util.UTF_8).equals(binaryAnnotations.get(b.key))) {
                    binaryAnnotations.remove(b.key);
                }
                if (b.endpoint == null) continue;
                serviceNames.add(b.endpoint.serviceName);
                currentServiceNames.add(b.endpoint.serviceName);
            }
            if ((request.serviceName == null || currentServiceNames.contains(request.serviceName)) && !testedDuration) {
                if (request.minDuration != null && request.maxDuration != null) {
                    testedDuration = span.duration >= request.minDuration && span.duration <= request.maxDuration;
                } else if (request.minDuration != null) {
                    boolean bl = testedDuration = span.duration >= request.minDuration;
                }
            }
            if (!span.name.equals(spanName)) continue;
            spanName = null;
        }
        return (request.serviceName == null || serviceNames.contains(request.serviceName)) && spanName == null && annotations.isEmpty() && binaryAnnotations.isEmpty() && testedDuration;
    }

    static abstract class Multimap<K, V> {
        private final Map<K, Collection<V>> delegate = new LinkedHashMap<K, Collection<V>>();

        Multimap() {
        }

        abstract Collection<V> valueContainer();

        Set<K> keySet() {
            return this.delegate.keySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(K key, V value) {
            Collection<V> valueContainer = this.delegate.get(key);
            if (valueContainer == null) {
                Map<K, Collection<V>> map = this.delegate;
                synchronized (map) {
                    if (!this.delegate.containsKey(key)) {
                        valueContainer = this.valueContainer();
                        this.delegate.put(key, valueContainer);
                    }
                }
            }
            valueContainer.add(value);
        }

        void clear() {
            this.delegate.clear();
        }

        Collection<V> get(K key) {
            return this.delegate.get(key);
        }
    }

    static final class LinkedHashSetMultimap<K, V>
    extends Multimap<K, V> {
        LinkedHashSetMultimap() {
        }

        @Override
        Collection<V> valueContainer() {
            return new LinkedHashSet();
        }
    }

    static final class SortedByValue2Descending<K>
    extends Multimap<K, Pair<Long>> {
        SortedByValue2Descending() {
        }

        @Override
        Set<Pair<Long>> valueContainer() {
            return new TreeSet<Pair<Long>>(VALUE_2_DESCENDING);
        }
    }

    static final class LinkedListMultimap<K, V>
    extends Multimap<K, V> {
        LinkedListMultimap() {
        }

        @Override
        Collection<V> valueContainer() {
            return new LinkedList();
        }
    }
}

