/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import zipkin.CollectorMetrics;
import zipkin.internal.Util;

public final class InMemoryCollectorMetrics
implements CollectorMetrics {
    private final ConcurrentHashMap<String, AtomicInteger> metrics;
    private final String messages;
    private final String messagesDropped;
    private final String bytes;
    private final String spans;
    private final String spansDropped;

    public InMemoryCollectorMetrics() {
        this(new ConcurrentHashMap<String, AtomicInteger>(), null);
    }

    InMemoryCollectorMetrics(ConcurrentHashMap<String, AtomicInteger> metrics, String transport) {
        this.metrics = metrics;
        this.messages = InMemoryCollectorMetrics.scope("messages", transport);
        this.messagesDropped = InMemoryCollectorMetrics.scope("messagesDropped", transport);
        this.bytes = InMemoryCollectorMetrics.scope("bytes", transport);
        this.spans = InMemoryCollectorMetrics.scope("spans", transport);
        this.spansDropped = InMemoryCollectorMetrics.scope("spansDropped", transport);
    }

    @Override
    public InMemoryCollectorMetrics forTransport(String transportType) {
        return new InMemoryCollectorMetrics(this.metrics, Util.checkNotNull(transportType, "transportType"));
    }

    @Override
    public void incrementMessages() {
        this.increment(this.messages, 1);
    }

    public int messages() {
        return this.get(this.messages);
    }

    @Override
    public void incrementMessagesDropped() {
        this.increment(this.messagesDropped, 1);
    }

    public int messagesDropped() {
        return this.get(this.messagesDropped);
    }

    @Override
    public void incrementBytes(int quantity) {
        this.increment(this.bytes, quantity);
    }

    public int bytes() {
        return this.get(this.bytes);
    }

    @Override
    public void incrementSpans(int quantity) {
        this.increment(this.spans, quantity);
    }

    public int spans() {
        return this.get(this.spans);
    }

    @Override
    public void incrementSpansDropped(int quantity) {
        this.increment(this.spansDropped, quantity);
    }

    public int spansDropped() {
        return this.get(this.spansDropped);
    }

    public void clear() {
        this.metrics.clear();
    }

    private int get(String key) {
        AtomicInteger atomic = this.metrics.get(key);
        return atomic == null ? 0 : atomic.get();
    }

    private void increment(String key, int quantity) {
        int update;
        int oldValue;
        if (quantity == 0) {
            return;
        }
        AtomicInteger metric = this.metrics.get(key);
        if (metric == null && (metric = this.metrics.putIfAbsent(key, new AtomicInteger(quantity))) == null) {
            return;
        }
        while (!metric.compareAndSet(oldValue = metric.get(), update = oldValue + quantity)) {
        }
    }

    static String scope(String key, String transport) {
        return key + (transport == null ? "" : "." + transport);
    }
}

