/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.util.List;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.JsonCodec;
import zipkin.internal.Nullable;
import zipkin.internal.ThriftCodec;

public interface Codec {
    public static final JsonCodec JSON = new JsonCodec();
    public static final ThriftCodec THRIFT = new ThriftCodec();
    public static final Factory FACTORY = new Factory(){

        @Override
        public Codec get(String mediaType) {
            if (mediaType.startsWith("application/json")) {
                return JSON;
            }
            if (mediaType.startsWith("application/x-thrift")) {
                return THRIFT;
            }
            return null;
        }
    };

    public Span readSpan(byte[] var1);

    public byte[] writeSpan(Span var1);

    public List<Span> readSpans(byte[] var1);

    public byte[] writeSpans(List<Span> var1);

    public byte[] writeTraces(List<List<Span>> var1);

    public List<DependencyLink> readDependencyLinks(byte[] var1);

    public byte[] writeDependencyLinks(List<DependencyLink> var1);

    public static interface Factory {
        @Nullable
        public Codec get(String var1);
    }
}

