/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing;

import io.shardingsphere.core.routing.RouteUnit;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BatchRouteUnit {
    private final RouteUnit routeUnit;
    private final Map<Integer, Integer> jdbcAndActualAddBatchCallTimesMap = new LinkedHashMap<Integer, Integer>();
    private int actualCallAddBatchTimes;

    public BatchRouteUnit(RouteUnit routeUnit) {
        this.routeUnit = routeUnit;
    }

    public void mapAddBatchCount(int jdbcAddBatchTimes) {
        this.jdbcAndActualAddBatchCallTimesMap.put(jdbcAddBatchTimes, this.actualCallAddBatchTimes++);
    }

    public RouteUnit getRouteUnit() {
        return this.routeUnit;
    }

    public Map<Integer, Integer> getJdbcAndActualAddBatchCallTimesMap() {
        return this.jdbcAndActualAddBatchCallTimesMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchRouteUnit)) {
            return false;
        }
        BatchRouteUnit other = (BatchRouteUnit)o;
        RouteUnit this$routeUnit = this.getRouteUnit();
        RouteUnit other$routeUnit = other.getRouteUnit();
        return !(this$routeUnit == null ? other$routeUnit != null : !((Object)this$routeUnit).equals(other$routeUnit));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RouteUnit $routeUnit = this.getRouteUnit();
        result = result * 59 + ($routeUnit == null ? 0 : ((Object)$routeUnit).hashCode());
        return result;
    }

    public String toString() {
        return "BatchRouteUnit(routeUnit=" + this.getRouteUnit() + ", jdbcAndActualAddBatchCallTimesMap=" + this.getJdbcAndActualAddBatchCallTimesMap() + ", actualCallAddBatchTimes=" + this.actualCallAddBatchTimes + ")";
    }
}

