/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl.dql;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.OrderDirection;
import io.shardingsphere.core.parsing.antlr.extractor.CollectionSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.item.ColumnNameOrderByItemSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.item.ExpressionOrderByItemSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.item.IndexOrderByItemSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.item.OrderByItemSegment;
import io.shardingsphere.core.util.NumberUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;

public final class OrderByItemExtractor
implements CollectionSQLSegmentExtractor {
    public Collection<OrderByItemSegment> extract(ParserRuleContext ancestorNode) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.ORDER_BY_ITEM)) {
            OrderDirection orderDirection = 2 == each.getChildCount() && OrderDirection.DESC.name().equalsIgnoreCase(each.getChild(1).getText()) ? OrderDirection.DESC : OrderDirection.ASC;
            Optional<ParserRuleContext> indexNode = ExtractorUtils.findFirstChildNode(each, RuleName.NUMBER);
            if (indexNode.isPresent()) {
                result.add(new IndexOrderByItemSegment(NumberUtil.getExactlyNumber(((ParserRuleContext)indexNode.get()).getText(), 10).intValue(), orderDirection, OrderDirection.ASC));
                continue;
            }
            Optional<ParserRuleContext> expressionNode = ExtractorUtils.findFirstChildNode(each, RuleName.EXPR);
            if (expressionNode.isPresent()) {
                result.add(new ExpressionOrderByItemSegment(((ParserRuleContext)expressionNode.get()).getText(), orderDirection, OrderDirection.ASC));
                continue;
            }
            Optional<ParserRuleContext> columnNameNode = ExtractorUtils.findFirstChildNode(each, RuleName.COLUMN_NAME);
            if (!columnNameNode.isPresent()) continue;
            result.add(new ColumnNameOrderByItemSegment(((ParserRuleContext)columnNameNode.get()).getText(), ((ParserRuleContext)each.getChild(0)).getStart().getStartIndex(), orderDirection, OrderDirection.ASC));
        }
        return result;
    }
}

