/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class ImmutableList {
    private ImmutableList() {
    }

    public static <T> List<T> copyOf(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return new ImmutableArrayList(list.toArray());
    }

    @SafeVarargs
    public static <T> List<T> of(T ... elements) {
        if (elements.length == 0) {
            return Collections.emptyList();
        }
        if (elements.length == 1) {
            return Collections.singletonList(elements[0]);
        }
        return new ImmutableArrayList(elements);
    }

    public static <T> List<T> of(T element) {
        return Collections.singletonList(element);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    static class ImmutableArrayList<E>
    extends AbstractList<E> {
        private final Object[] elements;

        ImmutableArrayList(Object[] elements) {
            this.elements = elements;
        }

        @Override
        public E get(int index) {
            if (index < 0 || index >= this.elements.length) {
                this.indexOutOfBound(index);
            }
            return this.getInternal(index);
        }

        E getInternal(int index) {
            return (E)this.elements[index];
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public Iterator<E> iterator() {
            return new ImmutableListIterator(this.elements.length);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ImmutableListIterator(this.elements.length);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index < 0 || index > this.elements.length) {
                this.indexOutOfBound(index);
            }
            return new ImmutableListIterator(this.elements.length, index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || fromIndex > toIndex) {
                this.indexOutOfBound(fromIndex);
            }
            if (toIndex > this.elements.length) {
                this.indexOutOfBound(toIndex);
            }
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ImmutableArrayList<E>(Arrays.copyOfRange(this.elements, fromIndex, toIndex));
        }

        @Override
        public String toString() {
            return Arrays.toString(this.elements);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.elements.length == 0;
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(this, 1296);
        }

        void indexOutOfBound(int index) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds, list size: " + this.elements.length);
        }

        private class ImmutableListIterator
        implements ListIterator<E> {
            private int cursor;
            private final int size;

            ImmutableListIterator(int size, int position) {
                this.size = size;
                this.cursor = position;
            }

            ImmutableListIterator(int size) {
                this(size, 0);
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.size;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ImmutableArrayList.this.getInternal(this.cursor++);
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public E previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return ImmutableArrayList.this.getInternal(--this.cursor);
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static final class Builder<T> {
        private List<T> elements = new ArrayList<T>();

        private Builder() {
        }

        public Builder<T> add(T element) {
            this.elements.add(element);
            return this;
        }

        public Builder<T> addAll(Collection<T> elements) {
            this.elements.addAll(elements);
            return this;
        }

        public List<T> build() {
            return ImmutableList.copyOf(this.elements);
        }
    }
}

