/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.wechat.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.JFinal;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.api.ApiResult;
import io.jboot.utils.StrUtil;
import io.jboot.wechat.controller.JbootWechatController;
import javax.servlet.http.HttpServletRequest;

public class WechatUserInterceptor
implements Interceptor {
    public static final String AUTHORIZE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={redirecturi}&response_type=code&scope=snsapi_userinfo&state=235#wechat_redirect";
    public static final String BASE_AUTHORIZE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={redirecturi}&response_type=code&scope=snsapi_base&state=235#wechat_redirect";

    public void intercept(Invocation inv) {
        JbootWechatController controller = (JbootWechatController)inv.getController();
        if (controller.isAllowVisit()) {
            this.doIntercept(inv);
            return;
        }
        controller.doNotAlloVisitRedirect();
    }

    private void doIntercept(Invocation inv) {
        String openid;
        Object user;
        JbootWechatController controller = (JbootWechatController)inv.getController();
        boolean isFromBaseScope = this.isFromBaseScope(inv);
        if (isFromBaseScope && (user = controller.doGetUserByOpenId(openid = (String)inv.getController().getSessionAttr("_jboot_wechat_open_id_"))) != null) {
            controller.setAttr("_jboot_user_object_", user);
            inv.invoke();
            return;
        }
        String wechatUserJson = (String)controller.getSessionAttr("_jboot_wechat_json_");
        if (this.validateUserJson(wechatUserJson)) {
            user = controller.doSaveOrUpdateUserByApiResult(ApiResult.create((String)wechatUserJson));
            if (user == null) {
                controller.renderText("can not save or update user when get user from wechat");
                return;
            }
            controller.setAttr("_jboot_user_object_", user);
            inv.invoke();
            return;
        }
        controller.clearWechatSession();
        String appid = ApiConfigKit.getAppId();
        HttpServletRequest request = controller.getRequest();
        String queryString = request.getQueryString();
        String toUrl = request.getRequestURI();
        if (StrUtil.isNotBlank(queryString)) {
            toUrl = toUrl.concat("?").concat(queryString);
        }
        String controllerKey = inv.getControllerKey();
        String callbackControllerKey = controllerKey + "/wechatCallback";
        if (!JFinal.me().getAllActionKeys().contains(callbackControllerKey)) {
            callbackControllerKey = controllerKey.substring(0, controllerKey.lastIndexOf("/")) + "/wechatCallback";
        }
        String redirectUrl = controller.getBaseUrl() + callbackControllerKey + "?goto=" + StrUtil.urlEncode(toUrl);
        redirectUrl = StrUtil.urlEncode(redirectUrl);
        String authUrl = isFromBaseScope ? AUTHORIZE_URL : BASE_AUTHORIZE_URL;
        String url = authUrl.replace("{redirecturi}", redirectUrl).replace("{appid}", appid.trim());
        controller.redirect(url);
    }

    protected boolean validateUserJson(String wechatUserJson) {
        return StrUtil.isNotBlank(wechatUserJson) && wechatUserJson.contains("openid") && wechatUserJson.contains("nickname") && wechatUserJson.contains("headimgurl");
    }

    protected boolean isFromBaseScope(Invocation inv) {
        String scope = (String)inv.getController().getSessionAttr("_jboot_wechat_scope_");
        return scope != null && "snsapi_base".equalsIgnoreCase(scope);
    }
}

