/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.render.ContentType;
import com.jfinal.render.RenderException;
import com.jfinal.render.TextRender;
import java.io.IOException;
import java.io.PrintWriter;

public class JbootTextRender
extends TextRender {
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private String text;
    private String contentType;

    public JbootTextRender(String text) {
        super(text);
        this.text = text;
        this.contentType = DEFAULT_CONTENT_TYPE;
    }

    public JbootTextRender(String text, String contentType) {
        super(text, contentType);
        this.text = text;
        this.contentType = contentType;
    }

    public JbootTextRender(String text, ContentType contentType) {
        super(text, contentType);
        this.text = text;
        this.contentType = contentType.value();
    }

    public void render() {
        try {
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType(this.contentType);
            this.response.setCharacterEncoding(JbootTextRender.getEncoding());
            PrintWriter writer = this.response.getWriter();
            writer.write(this.text);
        }
        catch (IOException e) {
            throw new RenderException((Throwable)e);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getContentType() {
        return this.contentType;
    }
}

