/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.flashmessage;

import com.jfinal.core.Controller;
import io.jboot.web.controller.JbootController;
import java.util.HashMap;
import java.util.Map;

public class FlashMessageManager {
    private static final String FLASH_SESSION_ATTR = "_JFM_";
    private static final FlashMessageManager ME = new FlashMessageManager();

    public static FlashMessageManager me() {
        return ME;
    }

    public void renderTo(Controller controller) {
        HashMap flash = (HashMap)controller.getSessionAttr(FLASH_SESSION_ATTR);
        if (flash == null || flash.isEmpty()) {
            return;
        }
        for (Map.Entry entry : flash.entrySet()) {
            controller.setAttr((String)entry.getKey(), entry.getValue());
        }
    }

    public void init(Controller controller) {
        if (!(controller instanceof JbootController)) {
            return;
        }
        HashMap<String, Object> flash = ((JbootController)controller).getFlashAttrs();
        if (flash == null || flash.isEmpty()) {
            return;
        }
        controller.setSessionAttr(FLASH_SESSION_ATTR, flash);
    }

    public void release(Controller controller) {
        if (controller.getSessionAttr(FLASH_SESSION_ATTR) == null) {
            return;
        }
        controller.removeSessionAttr(FLASH_SESSION_ATTR);
    }
}

