/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.core.Controller;
import com.jfinal.core.NotAction;
import io.jboot.support.jwt.JwtManager;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class JbootController
extends Controller {
    protected HashMap<String, Object> flash;
    private HashMap<String, Object> jwtMap;

    @NotAction
    public boolean isMobileBrowser() {
        return RequestUtil.isMobileBrowser(this.getRequest());
    }

    @NotAction
    public boolean isWechatBrowser() {
        return RequestUtil.isWechatBrowser(this.getRequest());
    }

    @NotAction
    public boolean isIEBrowser() {
        return RequestUtil.isIEBrowser(this.getRequest());
    }

    @NotAction
    public boolean isAjaxRequest() {
        return RequestUtil.isAjaxRequest(this.getRequest());
    }

    @NotAction
    public boolean isMultipartRequest() {
        return RequestUtil.isMultipartRequest(this.getRequest());
    }

    @NotAction
    public String getIPAddress() {
        return RequestUtil.getIpAddress(this.getRequest());
    }

    @NotAction
    public String getReferer() {
        return RequestUtil.getReferer(this.getRequest());
    }

    @NotAction
    public String getUserAgent() {
        return RequestUtil.getUserAgent(this.getRequest());
    }

    @NotAction
    public Controller setFlashAttr(String name, Object value) {
        if (this.flash == null) {
            this.flash = new HashMap();
        }
        this.flash.put(name, value);
        return this;
    }

    @NotAction
    public Controller setFlashMap(Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        if (this.flash == null) {
            this.flash = new HashMap();
        }
        this.flash.putAll(map);
        return this;
    }

    @NotAction
    public <T> T getFlashAttr(String name) {
        return (T)(this.flash == null ? null : this.flash.get(name));
    }

    @NotAction
    public HashMap<String, Object> getFlashAttrs() {
        return this.flash;
    }

    @NotAction
    public Controller setJwtAttr(String name, Object value) {
        if (this.jwtMap == null) {
            this.jwtMap = new HashMap();
        }
        this.jwtMap.put(name, value);
        return this;
    }

    @NotAction
    public Controller setJwtMap(Map map) {
        if (map == null) {
            throw new NullPointerException("map is null, u show invoke setJwtAttr() before. ");
        }
        if (this.jwtMap == null) {
            this.jwtMap = new HashMap();
        }
        this.jwtMap.putAll(map);
        return this;
    }

    @NotAction
    public <T> T getJwtAttr(String name) {
        return (T)(this.jwtMap == null ? null : this.jwtMap.get(name));
    }

    @NotAction
    public HashMap<String, Object> getJwtAttrs() {
        return this.jwtMap;
    }

    @NotAction
    public <T> T getJwtPara(String name) {
        return JwtManager.me().getPara(name);
    }

    @NotAction
    public Map getJwtParas() {
        return JwtManager.me().getParas();
    }

    @NotAction
    public String createJwtToken() {
        if (this.jwtMap == null) {
            throw new NullPointerException("jwt attrs is null");
        }
        return JwtManager.me().createJwtToken(this.jwtMap);
    }

    @NotAction
    public String getBaseUrl() {
        return RequestUtil.getBaseUrl(this.getRequest());
    }

    @NotAction
    public <T> T getRawObject(Class<T> tClass) {
        return (T)(StrUtil.isBlank((String)this.getRawData()) ? null : JSON.parseObject((String)this.getRawData(), tClass));
    }

    @NotAction
    public JSONObject getRawObject() {
        return StrUtil.isBlank((String)this.getRawData()) ? null : JSON.parseObject((String)this.getRawData());
    }

    @NotAction
    public String getPara(String name) {
        String value = super.getPara(name);
        return "".equals(value) ? null : value;
    }

    @NotAction
    public Map<String, String> getParas() {
        HashMap<String, String> map = null;
        Enumeration names = this.getParaNames();
        if (names != null) {
            map = new HashMap<String, String>();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, this.getPara(name));
            }
        }
        return map;
    }

    @NotAction
    public String getEscapePara(String name) {
        String value = super.getPara(name);
        if (value == null || "".equals(value)) {
            return null;
        }
        return StrUtil.escapeHtml(value);
    }

    @NotAction
    public String getEscapePara(String name, String defaultValue) {
        String value = super.getPara(name);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return StrUtil.escapeHtml(value);
    }
}

