/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.aop.Aop;
import com.jfinal.log.Log;
import io.jboot.aop.annotation.StaticConstruct;
import io.jboot.exception.JbootException;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassUtil {
    public static Log log = Log.getLog(ClassUtil.class);
    private static final Map<Class, Object> singletons = new ConcurrentHashMap<Class, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T singleton(Class<T> clazz) {
        Object object = singletons.get(clazz);
        if (object == null) {
            Class<T> clazz2 = clazz;
            synchronized (clazz2) {
                object = singletons.get(clazz);
                if (object == null) {
                    object = ClassUtil.newInstance(clazz);
                    if (object != null) {
                        singletons.put(clazz, object);
                    } else {
                        Log.getLog(clazz).error("cannot new newInstance!!!!");
                    }
                }
            }
        }
        return (T)object;
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ClassUtil.newInstance(clazz, true);
    }

    public static <T> T newInstance(Class<T> clazz, boolean createByAop) {
        if (createByAop) {
            return (T)Aop.get(clazz);
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("can not newInstance class:" + clazz + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstanceByStaticConstruct(Class<T> clazz) {
        StaticConstruct staticConstruct = clazz.getAnnotation(StaticConstruct.class);
        if (staticConstruct == null) {
            return null;
        }
        return ClassUtil.newInstanceByStaticConstruct(clazz, staticConstruct);
    }

    public static <T> T newInstanceByStaticConstruct(Class<T> clazz, StaticConstruct staticConstruct) {
        Method method = ClassUtil.getStaticConstruct(staticConstruct.value(), clazz);
        if (method == null) {
            throw new JbootException("can not new instance by static constrauct for class : " + clazz);
        }
        try {
            return (T)method.invoke(null, null);
        }
        catch (Exception e) {
            log.error("can not invoke method:" + method.getName() + " in class : " + clazz + "\n" + e.toString(), (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static Method getStaticConstruct(String name, Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() != clazz) continue;
            if (StrUtil.isBlank((String)name)) {
                return method;
            }
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public static <T> T newInstance(String clazzName) {
        return ClassUtil.newInstance(clazzName, true);
    }

    public static <T> T newInstance(String clazzName, boolean createByAop) {
        try {
            Class<?> clazz = Class.forName(clazzName, false, Thread.currentThread().getContextClassLoader());
            return (T)ClassUtil.newInstance(clazz, createByAop);
        }
        catch (Exception e) {
            log.error("can not newInstance class:" + clazzName + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static Class getUsefulClass(Class<?> clazz) {
        return clazz.getName().indexOf("$$EnhancerBy") == -1 ? clazz : clazz.getSuperclass();
    }

    public static String buildMethodString(Method method) {
        StringBuilder sb = new StringBuilder().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        Class<?>[] params = method.getParameterTypes();
        int in = 0;
        for (Class<?> clazz : params) {
            sb.append(clazz.getName());
            if (++in >= params.length) continue;
            sb.append(",");
        }
        return sb.append(")").toString();
    }
}

