/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import io.jboot.app.config.JbootConfigManager;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.StrUtil;

public class AnnotationUtil {
    public static String get(String value) {
        if (StrUtil.isBlank((String)value)) {
            return null;
        }
        if ((value = value.trim()).startsWith("${") && value.endsWith("}")) {
            String key = value.substring(2, value.length() - 1);
            return AnnotationUtil.getConfigValueByKeyString(key);
        }
        return value;
    }

    public static String getConfigValueByKeyString(String key) {
        String configValue;
        String returnValue;
        int indexOf = key.indexOf(":");
        String defaultValue = null;
        if (indexOf != -1) {
            defaultValue = key.substring(indexOf + 1);
            key = key.substring(0, indexOf);
        }
        return StrUtil.isBlank((String)(returnValue = StrUtil.obtainDefaultIfBlank(configValue = JbootConfigManager.me().getConfigValue(key.trim()), defaultValue))) ? null : returnValue.trim();
    }

    public static Integer getInt(String value) {
        String intValue = AnnotationUtil.get(value);
        if (intValue == null) {
            return null;
        }
        return Integer.valueOf(intValue);
    }

    public static Integer getInt(String value, int defaultValue) {
        String intValue = AnnotationUtil.get(value);
        if (intValue == null) {
            return defaultValue;
        }
        return Integer.valueOf(intValue);
    }

    public static Long getLong(String value) {
        String longValue = AnnotationUtil.get(value);
        if (longValue == null) {
            return null;
        }
        return Long.valueOf(longValue);
    }

    public static Long getLong(String value, long defaultValue) {
        String longValue = AnnotationUtil.get(value);
        if (longValue == null) {
            return defaultValue;
        }
        return Long.valueOf(longValue);
    }

    public static Boolean getBool(String value) {
        String boolValue = AnnotationUtil.get(value);
        if (boolValue == null) {
            return null;
        }
        return Boolean.valueOf(boolValue);
    }

    public static Boolean getBool(String value, boolean defaultValue) {
        String boolValue = AnnotationUtil.get(value);
        if (boolValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(boolValue);
    }

    public static String[] get(String[] value) {
        if (ArrayUtil.isNullOrEmpty(value)) {
            return null;
        }
        String[] rets = new String[value.length];
        for (int i = 0; i < rets.length; ++i) {
            rets[i] = AnnotationUtil.get(value[i]);
        }
        return rets;
    }
}

