/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro.directives;

import com.jfinal.template.Env;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.support.shiro.directives.JbootShiroDirectiveBase;
import io.jboot.utils.ArrayUtil;
import io.jboot.web.directive.annotation.JFinalDirective;

@JFinalDirective(value="shiroNotHasRole")
public class ShiroNotHasRoleDirective
extends JbootShiroDirectiveBase {
    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.getExprArray().length == 0) {
            throw new IllegalArgumentException("#shiroNotHasRole argument must not be empty");
        }
        super.setExprList(exprList);
    }

    @Override
    public void onRender(Env env, Scope scope, Writer writer) {
        boolean hasAnyRole = false;
        if (this.getSubject() != null && ArrayUtil.isNotEmpty(this.exprList.getExprArray())) {
            for (Expr expr : this.exprList.getExprArray()) {
                if (!this.getSubject().hasRole(expr.eval(scope).toString())) continue;
                hasAnyRole = true;
                break;
            }
        }
        if (!hasAnyRole) {
            this.renderBody(env, scope, writer);
        }
    }

    public boolean hasEnd() {
        return true;
    }
}

