/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.seata;

import com.jfinal.log.Log;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.rpc.Disposable;
import io.seata.core.rpc.netty.RmRpcClient;
import io.seata.core.rpc.netty.ShutdownHook;
import io.seata.core.rpc.netty.TmRpcClient;
import io.seata.rm.RMClient;
import io.seata.tm.TMClient;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;

public class SeataGlobalTransactionManager {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = Log.getLog(SeataGlobalTransactionManager.class);
    private final FailureHandler failureHandlerHook;
    private static final FailureHandler DEFAULT_FAIL_HANDLER = new DefaultFailureHandlerImpl();
    private final boolean disableGlobalTransaction = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
    private static final int AT_MODE = 1;
    private static final int MT_MODE = 2;
    private static final int DEFAULT_MODE = 3;
    private static final int ORDER_NUM = 1024;
    private final String applicationId;
    private final String txServiceGroup;
    private final int mode;

    public SeataGlobalTransactionManager(String txServiceGroup) {
        this(txServiceGroup, txServiceGroup, 3);
    }

    public SeataGlobalTransactionManager(String txServiceGroup, int mode) {
        this(txServiceGroup, txServiceGroup, mode);
    }

    public SeataGlobalTransactionManager(String applicationId, String txServiceGroup) {
        this(applicationId, txServiceGroup, 3);
    }

    public SeataGlobalTransactionManager(String applicationId, String txServiceGroup, int mode) {
        this(applicationId, txServiceGroup, mode, DEFAULT_FAIL_HANDLER);
    }

    public SeataGlobalTransactionManager(String applicationId, String txServiceGroup, FailureHandler failureHandlerHook) {
        this(applicationId, txServiceGroup, 3, failureHandlerHook);
    }

    public SeataGlobalTransactionManager(String applicationId, String txServiceGroup, int mode, FailureHandler failureHandler) {
        this.applicationId = applicationId;
        this.txServiceGroup = txServiceGroup;
        this.mode = mode;
        this.failureHandlerHook = failureHandler;
    }

    private void initClient() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing Global Transaction Clients ... ");
        }
        if (StringUtils.isNullOrEmpty((String)this.applicationId) || StringUtils.isNullOrEmpty((String)this.txServiceGroup)) {
            throw new IllegalArgumentException("applicationId: " + this.applicationId + ", txServiceGroup: " + this.txServiceGroup);
        }
        TMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transaction Manager Client is initialized. applicationId[" + this.applicationId + "] txServiceGroup[" + this.txServiceGroup + "]");
        }
        RMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Resource Manager is initialized. applicationId[" + this.applicationId + "] txServiceGroup[" + this.txServiceGroup + "]");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Global Transaction Clients are initialized. ");
        }
        this.registerSpringShutdownHook();
    }

    private void registerSpringShutdownHook() {
        ShutdownHook.removeRuntimeShutdownHook();
        ShutdownHook.getInstance().addDisposable((Disposable)TmRpcClient.getInstance((String)this.applicationId, (String)this.txServiceGroup));
        ShutdownHook.getInstance().addDisposable((Disposable)RmRpcClient.getInstance((String)this.applicationId, (String)this.txServiceGroup));
    }

    public void destroy() {
        ShutdownHook.getInstance().destroyAll();
    }

    public void init() {
        if (this.disableGlobalTransaction) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Global transaction is disabled.");
            }
            return;
        }
        this.initClient();
    }
}

