/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.service;

import com.jfinal.plugin.activerecord.Page;
import io.jboot.db.model.Columns;
import io.jboot.db.model.JbootModel;
import io.jboot.exception.JbootException;
import io.jboot.service.JbootServiceJoiner;
import io.jboot.service.JbootServiceJoinerImpl;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class JbootServiceBase<M extends JbootModel<M>>
extends JbootServiceJoinerImpl
implements JbootServiceJoiner {
    protected static final int ACTION_ADD = 1;
    protected static final int ACTION_DEL = 2;
    protected static final int ACTION_UPDATE = 3;
    protected M DAO = this.initDao();

    protected M initDao() {
        Type type = ClassUtil.getUsefulClass(this.getClass()).getGenericSuperclass();
        Class modelClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        if (modelClass == null) {
            throw new JbootException("can not get model class name in JbootServiceBase");
        }
        return (M)((Object)((JbootModel)((Object)ClassUtil.newInstance(modelClass, false))));
    }

    public M getDao() {
        return this.DAO;
    }

    public M findById(Object id) {
        return (M)((JbootModel)((Object)this.DAO)).findById(id);
    }

    public List<M> findAll() {
        return ((JbootModel)((Object)this.DAO)).findAll();
    }

    public boolean deleteById(Object id) {
        boolean result = ((JbootModel)((Object)this.DAO)).deleteById(id);
        if (result) {
            this.shouldUpdateCache(2, id);
        }
        return result;
    }

    public boolean delete(M model) {
        boolean result = ((JbootModel)((Object)model)).delete();
        if (result) {
            this.shouldUpdateCache(2, model);
        }
        return result;
    }

    public Object save(M model) {
        boolean result = ((JbootModel)((Object)model)).save();
        if (result) {
            this.shouldUpdateCache(1, model);
            return ((JbootModel)((Object)model))._getIdValue();
        }
        return null;
    }

    public Object saveOrUpdate(M model) {
        if (((JbootModel)((Object)model))._getIdValue() == null) {
            return this.save(model);
        }
        if (this.update(model)) {
            return ((JbootModel)((Object)model))._getIdValue();
        }
        return null;
    }

    public boolean update(M model) {
        boolean result = ((JbootModel)((Object)model)).update();
        if (result) {
            this.shouldUpdateCache(3, model);
        }
        return result;
    }

    public Page<M> paginate(int page, int pageSize) {
        return ((JbootModel)((Object)this.DAO)).paginate(page, pageSize);
    }

    public Page<M> paginateByColumns(int page, int pageSize, Columns columns) {
        return ((JbootModel)((Object)this.DAO)).paginateByColumns(page, pageSize, columns);
    }

    public Page<M> paginateByColumns(int page, int pageSize, Columns columns, String orderBy) {
        return ((JbootModel)((Object)this.DAO)).paginateByColumns(page, pageSize, columns, orderBy);
    }

    @Override
    protected JbootModel joinById(Object id) {
        return this.findById(id);
    }

    public void shouldUpdateCache(int action, Object data) {
    }
}

