/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import com.jfinal.core.JFinal;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Table;
import io.jboot.db.dialect.IJbootModelDialect;
import io.jboot.db.model.Column;
import io.jboot.db.model.Columns;
import io.jboot.db.model.JbootModelConfig;
import io.jboot.exception.JbootException;
import io.jboot.utils.StrUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class JbootModel<M extends JbootModel<M>>
extends Model<M> {
    public static final String AUTO_COPY_MODEL = "_auto_copy_model_";
    private static final String DATASOURCE_CACHE_PREFIX = "__ds__";
    private static JbootModelConfig config = JbootModelConfig.getConfig();
    private static String column_created = config.getColumnCreated();
    private static String column_modified = config.getColumnModified();
    private static boolean idCacheEnable = config.isIdCacheEnable();
    private transient Table table;
    private transient String[] primaryKeys;
    private transient Class<?> primaryType;

    public M copy() {
        JbootModel m = null;
        try {
            m = (JbootModel)((Object)this._getUsefulClass().newInstance());
            m.put(this._getAttrs());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return (M)((Object)m);
    }

    public M copyModel() {
        JbootModel m = null;
        try {
            m = (JbootModel)((Object)this._getUsefulClass().newInstance());
            Table table = this._getTable(true);
            Set attrKeys = table.getColumnTypeMap().keySet();
            for (String attrKey : attrKeys) {
                Object o = this.get(attrKey);
                if (o == null) continue;
                m.set(attrKey, o);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return (M)((Object)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M use(String configName) {
        JbootModel<M> m = (JbootModel)((Object)this.get(DATASOURCE_CACHE_PREFIX + configName));
        if (m == null) {
            String string = configName;
            synchronized (string) {
                m = (JbootModel)((Object)this.get(DATASOURCE_CACHE_PREFIX + configName));
                if (m == null) {
                    m = ((JbootModel)((Object)this.copy())).superUse(configName);
                    this.put(DATASOURCE_CACHE_PREFIX + configName, m);
                }
            }
        }
        return (M)((Object)m);
    }

    M superUse(String configName) {
        return (M)((Object)((JbootModel)super.use(configName)));
    }

    public boolean saveOrUpdate() {
        if (null == this._getIdValue()) {
            return this.save();
        }
        return this.update();
    }

    public boolean save() {
        boolean needInitPrimaryKey;
        if (this._hasColumn(column_created) && this.get(column_created) == null) {
            this.set(column_created, new Date());
        }
        boolean bl = needInitPrimaryKey = String.class == this._getPrimaryType() && null == this.get(this._getPrimaryKey());
        if (needInitPrimaryKey) {
            this.set(this._getPrimaryKey(), this.generatePrimaryValue());
        }
        boolean saveSuccess = false;
        Boolean autoCopyModel = (Boolean)this.get(AUTO_COPY_MODEL);
        if (autoCopyModel != null && autoCopyModel.booleanValue()) {
            M copyModel = this.copyModel();
            saveSuccess = ((JbootModel)((Object)copyModel)).superSave();
            if (saveSuccess && !needInitPrimaryKey) {
                this.set(this._getPrimaryKey(), copyModel.get(this._getPrimaryKey()));
            }
        } else {
            saveSuccess = this.superSave();
        }
        return saveSuccess;
    }

    protected boolean superSave() {
        return super.save();
    }

    protected String generatePrimaryValue() {
        return StrUtil.uuid();
    }

    public M findById(Object idValue) {
        if (idValue == null) {
            return null;
        }
        return (M)(idCacheEnable ? this.loadByCache(idValue) : (JbootModel)super.findById(idValue));
    }

    public M findByIds(Object ... idValues) {
        if (idValues == null) {
            return null;
        }
        if (idValues.length != this._getPrimaryKeys().length) {
            throw new IllegalArgumentException("idValues.length != _getPrimaryKeys().length");
        }
        return (M)(idCacheEnable ? this.loadByCache(idValues) : (JbootModel)super.findByIds(idValues));
    }

    protected M loadByCache(Object ... idValues) {
        return (M)((Object)((JbootModel)((Object)config.getCache().get(this._getTableName(), JbootModel.buildCacheKey(idValues), () -> (JbootModel)JbootModel.super.findByIds(idValues), config.getIdCacheTime()))));
    }

    public boolean delete() {
        boolean success = super.delete();
        if (success && idCacheEnable) {
            this.deleteIdCache();
        }
        return success;
    }

    public boolean deleteById(Object idValue) {
        boolean success = super.deleteById(idValue);
        if (success && idCacheEnable) {
            this.deleteIdCacheById(idValue);
        }
        return success;
    }

    public boolean deleteByIds(Object ... idValues) {
        boolean success = super.deleteByIds(idValues);
        if (success && idCacheEnable) {
            this.deleteIdCacheById(idValues);
        }
        return success;
    }

    public boolean update() {
        boolean success;
        if (this._hasColumn(column_modified)) {
            this.set(column_modified, new Date());
        }
        boolean bl = success = this.isAutoCopyModel() ? ((JbootModel)((Object)this.copyModel())).superUpdate() : this.superUpdate();
        if (success && idCacheEnable) {
            this.deleteIdCache();
        }
        return success;
    }

    private boolean isAutoCopyModel() {
        Boolean autoCopyModel = (Boolean)this.get(AUTO_COPY_MODEL);
        return autoCopyModel != null && autoCopyModel == true;
    }

    protected boolean superUpdate() {
        return super.update();
    }

    public void deleteIdCache() {
        if (this._getPrimaryKeys().length == 1) {
            Object idValue = this.get(this._getPrimaryKey());
            this.deleteIdCacheById(idValue);
        } else {
            Object[] idvalues = new Object[this._getPrimaryKeys().length];
            for (int i = 0; i < idvalues.length; ++i) {
                idvalues[i] = this.get(this._getPrimaryKeys()[i]);
            }
            this.deleteIdCacheById(idvalues);
        }
    }

    public void deleteIdCacheById(Object ... idvalues) {
        config.getCache().remove(this._getTableName(), JbootModel.buildCacheKey(idvalues));
    }

    private static String buildCacheKey(Object ... idValues) {
        if (idValues == null || idValues.length == 0) {
            return null;
        }
        if (idValues.length == 1) {
            return idValues[0].toString();
        }
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < idValues.length; ++i) {
            key.append(idValues[i]);
            if (i >= idValues.length - 1) continue;
            key.append(":");
        }
        return key.toString();
    }

    protected IJbootModelDialect _getDialect() {
        Config config = this._getConfig();
        if (config == null) {
            throw new JbootException(String.format("class %s can not mapping to database table, maybe cannot connect to database. ", this._getUsefulClass().getName()));
        }
        return (IJbootModelDialect)config.getDialect();
    }

    public M findFirstByColumn(String column, Object value) {
        return this.findFirstByColumn(Column.create(column, value));
    }

    public M findFirstByColumn(String column, Object value, String orderBy) {
        return this.findFirstByColumn(Column.create(column, value), orderBy);
    }

    public M findFirstByColumn(Column column) {
        return this.findFirstByColumns(Columns.create(column));
    }

    public M findFirstByColumn(Column column, String orderBy) {
        return this.findFirstByColumns(Columns.create(column), orderBy);
    }

    public M findFirstByColumns(Columns columns) {
        return this.findFirstByColumns(columns, null);
    }

    public M findFirstByColumns(Columns columns, String orderby) {
        String sql = this._getDialect().forFindByColumns(this._getTableName(), "*", columns.getList(), orderby, 1);
        return (M)((Object)(columns.isEmpty() ? (JbootModel<M>)this.findFirst(sql) : this.findFirst(sql, columns.getValueArray())));
    }

    public List<M> findAll() {
        String sql = this._getDialect().forFindByColumns(this._getTableName(), "*", null, null, null);
        return this.find(sql);
    }

    public List<M> findListByColumn(String column, Object value) {
        return this.findListByColumn(Column.create(column, value), null, null);
    }

    public List<M> findListByColumn(Column column) {
        return this.findListByColumn(column, null, null);
    }

    public List<M> findListByColumn(String column, Object value, Integer count) {
        return this.findListByColumn(Column.create(column, value), null, count);
    }

    public List<M> findListByColumn(Column column, Integer count) {
        return this.findListByColumn(column, null, count);
    }

    public List<M> findListByColumn(String column, Object value, String orderBy) {
        return this.findListByColumn(Column.create(column, value), orderBy, null);
    }

    public List<M> findListByColumn(Column column, String orderby) {
        return this.findListByColumn(column, orderby, null);
    }

    public List<M> findListByColumn(String column, Object value, String orderBy, Integer count) {
        return this.findListByColumn(Column.create(column, value), orderBy, count);
    }

    public List<M> findListByColumn(Column column, String orderBy, Integer count) {
        return this.findListByColumns(Columns.create(column), orderBy, count);
    }

    public List<M> findListByColumns(List<Column> columns) {
        return this.findListByColumns(columns, null, null);
    }

    public List<M> findListByColumns(List<Column> columns, String orderBy) {
        return this.findListByColumns(columns, orderBy, null);
    }

    public List<M> findListByColumns(List<Column> columns, Integer count) {
        return this.findListByColumns(columns, null, count);
    }

    public List<M> findListByColumns(List<Column> columns, String orderBy, Integer count) {
        return this.findListByColumns(Columns.create(columns), orderBy, count);
    }

    public List<M> findListByColumns(Columns columns) {
        return this.findListByColumns(columns, null, null);
    }

    public List<M> findListByColumns(Columns columns, String orderBy) {
        return this.findListByColumns(columns, orderBy, null);
    }

    public List<M> findListByColumns(Columns columns, Integer count) {
        return this.findListByColumns(columns, null, count);
    }

    public List<M> findListByColumns(Columns columns, String orderBy, Integer count) {
        String sql = this._getDialect().forFindByColumns(this._getTableName(), "*", columns.getList(), orderBy, count);
        return columns.isEmpty() ? this.find(sql) : this.find(sql, columns.getValueArray());
    }

    public Page<M> paginate(int pageNumber, int pageSize) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(), null);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(), orderBy);
    }

    public Page<M> paginateByColumn(int pageNumber, int pageSize, Column column) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(column), null);
    }

    public Page<M> paginateByColumn(int pageNumber, int pageSize, Column column, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(column), orderBy);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, Columns columns) {
        return this.paginateByColumns(pageNumber, pageSize, columns, null);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, List<Column> columns) {
        return this.paginateByColumns(pageNumber, pageSize, columns, null);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, List<Column> columns, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(columns), orderBy);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, Columns columns, String orderBy) {
        String selectPartSql = this._getDialect().forPaginateSelect("*");
        String fromPartSql = this._getDialect().forPaginateFrom(this._getTableName(), columns.getList(), orderBy);
        return columns.isEmpty() ? this.paginate(pageNumber, pageSize, selectPartSql, fromPartSql) : this.paginate(pageNumber, pageSize, selectPartSql, fromPartSql, columns.getValueArray());
    }

    public <T> T _getIdValue() {
        return (T)this.get(this._getPrimaryKey());
    }

    public String _getTableName() {
        return this._getTable(true).getName();
    }

    public Table _getTable() {
        return this._getTable(false);
    }

    public Table _getTable(boolean validateNull) {
        if (this.table == null) {
            this.table = super._getTable();
            if (this.table == null && validateNull) {
                throw new JbootException(String.format("class %s can not mapping to database table,maybe application cannot connect to database. ", this._getUsefulClass().getName()));
            }
        }
        return this.table;
    }

    public String _getPrimaryKey() {
        return this._getPrimaryKeys()[0];
    }

    public String[] _getPrimaryKeys() {
        if (this.primaryKeys != null) {
            return this.primaryKeys;
        }
        this.primaryKeys = this._getTable(true).getPrimaryKey();
        if (this.primaryKeys == null) {
            throw new JbootException(String.format("primaryKeys == null in [%s]", ((Object)((Object)this)).getClass()));
        }
        return this.primaryKeys;
    }

    protected Class<?> _getPrimaryType() {
        if (this.primaryType == null) {
            this.primaryType = this._getTable(true).getColumnType(this._getPrimaryKey());
        }
        return this.primaryType;
    }

    protected boolean _hasColumn(String columnLabel) {
        return this._getTable(true).hasColumnLabel(columnLabel);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return super.paginate(pageNumber, pageSize, select, sqlExceptSelect);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return super.paginate(pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    public Page<M> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return super.paginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public List<M> find(String sql, Object ... paras) {
        this.debugPrintParas(paras);
        return super.find(sql, paras);
    }

    public M findFirst(String sql, Object ... paras) {
        this.debugPrintParas(paras);
        return (M)((Object)((JbootModel)super.findFirst(sql, paras)));
    }

    public List<M> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        return super.findByCache(cacheName, key, sql, paras);
    }

    public M findFirstByCache(String cacheName, Object key, String sql, Object ... paras) {
        return (M)((Object)((JbootModel)super.findFirstByCache(cacheName, key, sql, paras)));
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return super.paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return super.paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return super.paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect);
    }

    private void debugPrintParas(Object ... objects) {
        if (JFinal.me().getConstants().getDevMode()) {
            System.out.println("\r\n---------------Paras: " + Arrays.toString(objects) + "----------------");
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof JbootModel)) {
            return false;
        }
        if (this._getTable(false) == null) {
            return this == o;
        }
        Object id = ((JbootModel)((Object)o))._getIdValue();
        return id != null && id.equals(this._getIdValue());
    }

    public M preventXssAttack() {
        String[] attrNames;
        for (String attrName : attrNames = this._getAttrNames()) {
            Object value = this.get(attrName);
            if (value == null || !(value instanceof String)) continue;
            this.set(attrName, StrUtil.escapeHtml((String)value));
        }
        return (M)((Object)this);
    }

    public M preventXssAttack(String ... ignoreAttrs) {
        String[] attrNames;
        for (String attrName : attrNames = this._getAttrNames()) {
            Object value = this.get(attrName);
            if (value == null || !(value instanceof String)) continue;
            boolean isContinue = false;
            for (String ignoreAttr : ignoreAttrs) {
                if (!attrName.equals(ignoreAttr)) continue;
                isContinue = true;
                break;
            }
            if (isContinue) continue;
            this.set(attrName, StrUtil.escapeHtml((String)value));
        }
        return (M)((Object)this);
    }
}

