/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import io.jboot.db.dialect.JbootMysqlDialect;
import io.jboot.db.dialect.JbootSqlServerDialect;
import io.jboot.db.model.Column;
import io.jboot.db.model.Or;
import io.jboot.utils.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Columns
implements Serializable {
    private List<Column> cols;
    static final Object[] NULL_PARA_ARRAY = new Object[0];

    public static Columns create() {
        return new Columns();
    }

    public static Columns create(Column column) {
        Columns that = new Columns();
        that.add(column);
        return that;
    }

    public static Columns create(List<Column> columns) {
        Columns that = new Columns();
        that.cols = columns;
        return that;
    }

    public static Columns create(String name, Object value) {
        return Columns.create().eq(name, value);
    }

    public void add(Column column) {
        if (column.isMustNeedValue() && column.getValue() == null) {
            return;
        }
        if (this.cols == null) {
            this.cols = new LinkedList<Column>();
        }
        this.cols.add(column);
    }

    public Columns add(String name, Object value) {
        return this.eq(name, value);
    }

    public Columns eq(String name, Object value) {
        this.add(Column.create(name, value));
        return this;
    }

    public Columns ne(String name, Object value) {
        this.add(Column.create(name, value, " != "));
        return this;
    }

    public Columns like(String name, Object value) {
        this.add(Column.create(name, value, " LIKE "));
        return this;
    }

    public Columns likeAppendPercent(String name, Object value) {
        if (value == null || StrUtil.isBlank((String)value.toString())) {
            return this;
        }
        this.add(Column.create(name, "%" + value + "%", " LIKE "));
        return this;
    }

    public Columns gt(String name, Object value) {
        this.add(Column.create(name, value, " > "));
        return this;
    }

    public Columns ge(String name, Object value) {
        this.add(Column.create(name, value, " >= "));
        return this;
    }

    public Columns lt(String name, Object value) {
        this.add(Column.create(name, value, " < "));
        return this;
    }

    public Columns le(String name, Object value) {
        this.add(Column.create(name, value, " <= "));
        return this;
    }

    public Columns is_null(String name) {
        this.add(Column.create(name, null, " IS NULL "));
        return this;
    }

    public Columns is_not_null(String name) {
        this.add(Column.create(name, null, " IS NOT NULL "));
        return this;
    }

    public Columns or() {
        this.add(new Or());
        return this;
    }

    public Columns in(String name, Object ... arrays) {
        this.add(Column.create(name, arrays, " IN "));
        return this;
    }

    public Columns between(String name, Object start, Object end) {
        this.add(Column.create(name, new Object[]{start, end}, " BETWEEN "));
        return this;
    }

    public boolean isEmpty() {
        return this.cols == null || this.cols.isEmpty();
    }

    public Object[] getValueArray() {
        if (this.isEmpty()) {
            return NULL_PARA_ARRAY;
        }
        LinkedList<Object> values = new LinkedList<Object>();
        for (Column column : this.cols) {
            Object value = column.getValue();
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] vs;
                for (Object v : vs = (Object[])value) {
                    values.add(v);
                }
                continue;
            }
            values.add(value);
        }
        return values.isEmpty() ? NULL_PARA_ARRAY : values.toArray();
    }

    public List<Column> getList() {
        return this.cols;
    }

    public String getCacheKey() {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<Column> columns = new ArrayList<Column>(this.cols);
        StringBuilder s = new StringBuilder();
        for (Column column : columns) {
            if (column instanceof Or) {
                s.append("or").append("-");
                continue;
            }
            s.append(column.getName()).append("-").append(this.getLogicStr(column.getLogic())).append("-");
            Object value = column.getValue();
            if (value == null) continue;
            if (value.getClass().isArray()) {
                s.append(Arrays.toString((Object[])column.getValue()));
            } else {
                s.append(column.getValue());
            }
            s.append("-");
        }
        return s.deleteCharAt(s.length() - 1).toString();
    }

    private String getLogicStr(String logic) {
        switch (logic) {
            case " LIKE ": {
                return "lk";
            }
            case " > ": {
                return "gt";
            }
            case " >= ": {
                return "ge";
            }
            case " < ": {
                return "lt";
            }
            case " <= ": {
                return "le";
            }
            case " = ": {
                return "eq";
            }
            case " != ": {
                return "neq";
            }
            case " IS NULL ": {
                return "isn";
            }
            case " IS NOT NULL ": {
                return "nn";
            }
            case " IN ": {
                return "in";
            }
            case " BETWEEN ": {
                return "bt";
            }
        }
        return "";
    }

    public String toMysqlSql() {
        JbootMysqlDialect dialect = new JbootMysqlDialect();
        return dialect.forFindByColumns("table", "*", this.getList(), null, null);
    }

    public String toSqlServerSql() {
        JbootSqlServerDialect dialect = new JbootSqlServerDialect();
        return dialect.forFindByColumns("table", "*", this.getList(), null, null);
    }

    public static void main(String[] args) {
        Columns columns = Columns.create();
        System.out.println(columns.getCacheKey());
        columns.add("name", "zhangsan");
        System.out.println(columns.getCacheKey());
        columns.ge("age", 10);
        System.out.println(columns.getCacheKey());
        columns.or();
        System.out.println(columns.getCacheKey());
        columns.is_not_null("price");
        System.out.println(columns.getCacheKey());
        columns.is_null("nickname");
        System.out.println(columns.getCacheKey());
        columns.or();
        columns.in("name", "123", "123", "111");
        System.out.println(columns.getCacheKey());
        columns.or();
        columns.between("name", "123", "1233");
        System.out.println(columns.getCacheKey());
        System.out.println(Arrays.toString(columns.getValueArray()));
        System.out.println(columns.toMysqlSql());
        System.out.println(columns.toSqlServerSql());
    }
}

