/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import java.io.Serializable;

public class Column
implements Serializable {
    public static final String LOGIC_LIKE = " LIKE ";
    public static final String LOGIC_GT = " > ";
    public static final String LOGIC_GE = " >= ";
    public static final String LOGIC_LT = " < ";
    public static final String LOGIC_LE = " <= ";
    public static final String LOGIC_EQUALS = " = ";
    public static final String LOGIC_NOT_EQUALS = " != ";
    public static final String LOGIC_IS_NULL = " IS NULL ";
    public static final String LOGIC_IS_NOT_NULL = " IS NOT NULL ";
    public static final String LOGIC_IN = " IN ";
    public static final String LOGIC_BETWEEN = " BETWEEN ";
    private String name;
    private Object value;
    private String logic = " = ";

    public static Column create(String name) {
        Column column = new Column();
        column.setName(name);
        return column;
    }

    public static Column create(String name, Object value) {
        Column column = new Column();
        column.setName(name);
        column.setValue(value);
        return column;
    }

    public static Column create(String name, Object value, String logic) {
        Column column = new Column();
        column.setName(name);
        column.setValue(value);
        column.setLogic(logic);
        return column;
    }

    public Column logic(String logic) {
        this.setLogic(logic);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getLogic() {
        return this.logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public boolean isMustNeedValue() {
        return !LOGIC_IS_NULL.equals(this.getLogic()) && !LOGIC_IS_NOT_NULL.equals(this.getLogic());
    }
}

