/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.collect.Sets;
import com.jfinal.log.Log;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.db.datasource.DataSourceFactory;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;

public class DruidDataSourceFactory
implements DataSourceFactory {
    static Log log = Log.getLog(DruidDataSourceFactory.class);

    @Override
    public DataSource createDataSource(DataSourceConfig config) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(config.getUrl());
        druidDataSource.setUsername(config.getUser());
        druidDataSource.setPassword(config.getPassword());
        druidDataSource.setDriverClassName(config.getDriverClassName());
        druidDataSource.setMaxActive(config.getMaximumPoolSize());
        if (config.getMinimumIdle() != null) {
            druidDataSource.setMinIdle(config.getMinimumIdle().intValue());
        }
        if (config.getConnectionInitSql() != null) {
            druidDataSource.setConnectionInitSqls((Collection)Sets.newHashSet((Object[])new String[]{config.getConnectionInitSql()}));
        }
        try {
            druidDataSource.setFilters("stat");
        }
        catch (SQLException e) {
            log.error("DruidDataSourceFactory is error", (Throwable)e);
        }
        return druidDataSource;
    }
}

