/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.datasource;

import com.jfinal.kit.PathKit;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.db.datasource.DataSourceFactory;
import io.jboot.db.datasource.DruidDataSourceFactory;
import io.jboot.db.datasource.HikariDataSourceFactory;
import io.jboot.exception.JbootException;
import io.jboot.support.seata.JbootSeataManager;
import io.jboot.utils.StrUtil;
import io.shardingsphere.shardingjdbc.api.yaml.YamlShardingDataSourceFactory;
import java.io.File;
import javax.sql.DataSource;

public class DataSourceBuilder {
    private DataSourceConfig config;

    public DataSourceBuilder(DataSourceConfig datasourceConfig) {
        this.config = datasourceConfig;
    }

    public DataSource build() {
        String shardingConfigYaml = this.config.getShardingConfigYaml();
        if (StrUtil.isBlank((String)shardingConfigYaml)) {
            DataSource ds = this.createDataSource(this.config);
            return JbootSeataManager.me().wrapDataSource(ds);
        }
        File yamlFile = shardingConfigYaml.startsWith(File.separator) ? new File(shardingConfigYaml) : new File(PathKit.getRootClassPath(), shardingConfigYaml);
        try {
            return YamlShardingDataSourceFactory.createDataSource((File)yamlFile);
        }
        catch (Exception e) {
            throw new JbootException(e);
        }
    }

    private DataSource createDataSource(DataSourceConfig dsc) {
        String factory = dsc.getFactory();
        if (StrUtil.isBlank((String)factory)) {
            return new HikariDataSourceFactory().createDataSource(dsc);
        }
        switch (factory) {
            case "hikari": 
            case "hikariCP": 
            case "hikaricp": {
                return new HikariDataSourceFactory().createDataSource(dsc);
            }
            case "druid": {
                return new DruidDataSourceFactory().createDataSource(dsc);
            }
        }
        DataSourceFactory dataSourceFactory = JbootSpiLoader.load(DataSourceFactory.class, factory);
        if (dataSourceFactory == null) {
            throw new NullPointerException("can not load DataSourceFactory spi for name : " + factory);
        }
        return dataSourceFactory.createDataSource(dsc);
    }
}

