/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.log.Log;
import io.jboot.components.serializer.JbootSerializer;

public class FastjsonSerializer
implements JbootSerializer {
    private static final Log LOG = Log.getLog(FastjsonSerializer.class);

    @Override
    public byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        FastJsonCacheObject object = new FastJsonCacheObject(obj.getClass(), obj);
        String string = JSON.toJSONString((Object)object);
        return string.getBytes();
    }

    @Override
    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        String json = new String(bytes);
        JSONObject jsonObject = JSON.parseObject((String)json);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(jsonObject.getString("clazz"));
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.toString(), (Throwable)e);
            return null;
        }
        return jsonObject.getObject("object", clazz);
    }

    public static class FastJsonCacheObject {
        private Class clazz;
        private Object object;

        public FastJsonCacheObject() {
        }

        public FastJsonCacheObject(Class clazz, Object object) {
            this.clazz = clazz;
            this.object = object;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }
}

