/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.motan;

import com.weibo.api.motan.config.AbstractInterfaceConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RefererConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.ServiceConfig;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import io.jboot.components.rpc.JbootrpcBase;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootMotanrpc
extends JbootrpcBase {
    private RegistryConfig registryConfig = new RegistryConfig();
    private ProtocolConfig protocolConfig;
    private static final Map<String, Object> singletons = new ConcurrentHashMap<String, Object>();

    public JbootMotanrpc() {
        this.registryConfig.setCheck(String.valueOf(this.getConfig().isRegistryCheck()));
        if (this.getConfig().isRegistryCallMode()) {
            this.registryConfig.setRegProtocol(this.getConfig().getRegistryType());
            this.registryConfig.setAddress(this.getConfig().getRegistryAddress());
            this.registryConfig.setName(this.getConfig().getRegistryName());
        } else if (this.getConfig().isDirectCallMode()) {
            this.registryConfig.setRegProtocol("local");
        }
        this.protocolConfig = new ProtocolConfig();
        this.protocolConfig.setId("motan");
        this.protocolConfig.setName("motan");
        if (StrUtil.isNotBlank(this.getConfig().getProxy())) {
            this.protocolConfig.setFilter(this.getConfig().getProxy());
        }
        if (StrUtil.isNotBlank(this.getConfig().getSerialization())) {
            this.protocolConfig.setSerialization(this.getConfig().getSerialization());
        }
    }

    @Override
    public <T> T serviceObtain(Class<T> serviceClass, JbootrpcServiceConfig serviceConfig) {
        String key = String.format("%s:%s:%s", serviceClass.getName(), serviceConfig.getGroup(), serviceConfig.getVersion());
        Object object = singletons.get(key);
        if (object != null) {
            return (T)object;
        }
        RefererConfig refererConfig = new RefererConfig();
        refererConfig.setProtocol(this.protocolConfig);
        refererConfig.setInterface(serviceClass);
        refererConfig.setCheck(String.valueOf(this.getConfig().isConsumerCheck()));
        JbootMotanrpc.initInterface((AbstractInterfaceConfig)refererConfig, serviceConfig);
        if (this.getConfig().isRegistryCallMode()) {
            refererConfig.setRegistry(this.registryConfig);
        } else if (this.getConfig().isDirectCallMode()) {
            if (StrUtil.isBlank((String)this.getConfig().getDirectUrl())) {
                throw new JbootIllegalConfigException("directUrl must not be blank if you use direct call mode\uff0cplease config jboot.rpc.directUrl value");
            }
            refererConfig.setDirectUrl(this.getConfig().getDirectUrl());
        }
        object = refererConfig.getRef();
        if (object != null) {
            singletons.put(key, object);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean serviceExport(Class<T> interfaceClass, Object object, JbootrpcServiceConfig serviceConfig) {
        JbootMotanrpc jbootMotanrpc = this;
        synchronized (jbootMotanrpc) {
            MotanSwitcherUtil.setSwitcherValue((String)"feature.configserver.heartbeat", (boolean)false);
            ServiceConfig motanServiceConfig = new ServiceConfig();
            motanServiceConfig.setRegistry(this.registryConfig);
            motanServiceConfig.setProtocol(this.protocolConfig);
            motanServiceConfig.setInterface(interfaceClass);
            motanServiceConfig.setRef(object);
            if (StrUtil.isNotBlank(this.getConfig().getHost())) {
                motanServiceConfig.setHost(this.getConfig().getHost());
            }
            motanServiceConfig.setShareChannel(Boolean.valueOf(true));
            motanServiceConfig.setExport(String.format("motan:%s", serviceConfig.getPort()));
            motanServiceConfig.setCheck(String.valueOf(this.getConfig().isProviderCheck()));
            JbootMotanrpc.initInterface((AbstractInterfaceConfig)motanServiceConfig, serviceConfig);
            motanServiceConfig.export();
            MotanSwitcherUtil.setSwitcherValue((String)"feature.configserver.heartbeat", (boolean)true);
        }
        return true;
    }

    private static void initInterface(AbstractInterfaceConfig interfaceConfig, JbootrpcServiceConfig config) {
        interfaceConfig.setGroup(config.getGroup());
        interfaceConfig.setVersion(config.getVersion());
        interfaceConfig.setRequestTimeout(config.getTimeout());
        if (config.getActives() != null) {
            interfaceConfig.setActives(config.getActives());
        }
        if (config.getAsync() != null) {
            interfaceConfig.setAsync(config.getAsync());
        }
        if (config.getRetries() != null) {
            interfaceConfig.setRetries(config.getRetries());
        }
        if (config.getCheck() != null) {
            interfaceConfig.setCheck(config.getCheck().toString());
        }
        if (StrUtil.isNotBlank(config.getProxy())) {
            interfaceConfig.setProxy(config.getProxy());
        }
        if (StrUtil.isNotBlank(config.getFilter())) {
            interfaceConfig.setFilter(config.getFilter());
        }
    }
}

