/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc;

import io.jboot.Jboot;
import io.jboot.components.rpc.JbootrpcConfig;
import io.jboot.components.rpc.annotation.RPCBean;
import io.jboot.components.rpc.annotation.RPCInject;
import io.jboot.utils.AnnotationUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class JbootrpcServiceConfig
implements Serializable {
    private int port = defaultConfig.getDefaultPort();
    private String group = defaultConfig.getDefaultGroup();
    private String version = defaultConfig.getDefaultVersion();
    private Integer timeout = defaultConfig.getRequestTimeOut();
    private Integer retries = defaultConfig.getRetries();
    private Integer actives;
    private String loadbalance;
    private Boolean async;
    private Boolean check;
    private String proxy = defaultConfig.getProxy();
    private String filter = defaultConfig.getFilter();
    private Map<Object, Object> params;
    private static JbootrpcConfig defaultConfig = Jboot.config(JbootrpcConfig.class);

    public JbootrpcServiceConfig() {
    }

    public JbootrpcServiceConfig(RPCInject inject) {
        this();
        int port = AnnotationUtil.getInt(inject.port(), -1);
        int timeout = AnnotationUtil.getInt(inject.timeout(), -1);
        int retries = AnnotationUtil.getInt(inject.retries(), -1);
        int actives = AnnotationUtil.getInt(inject.actives(), -1);
        String group = AnnotationUtil.get(inject.group());
        String version = AnnotationUtil.get(inject.version());
        String loadbalance = AnnotationUtil.get(inject.loadbalance());
        Boolean async = AnnotationUtil.getBool(inject.async());
        Boolean check = AnnotationUtil.getBool(inject.check());
        if (port >= 0) {
            this.port = port;
        }
        if (retries >= 0) {
            this.retries = retries;
        }
        if (actives >= 0) {
            this.actives = actives;
        }
        if (timeout >= 0) {
            this.timeout = timeout;
        }
        if (group != null) {
            this.group = group;
        }
        if (version != null) {
            this.version = version;
        }
        if (loadbalance != null) {
            this.loadbalance = loadbalance;
        }
        if (async != null) {
            this.async = async;
        }
        if (check != null) {
            this.check = check;
        }
    }

    public JbootrpcServiceConfig(RPCBean bean) {
        this();
        int port = AnnotationUtil.getInt(bean.port(), -1);
        int timeout = AnnotationUtil.getInt(bean.timeout(), -1);
        int actives = AnnotationUtil.getInt(bean.actives(), -1);
        String group = AnnotationUtil.get(bean.group());
        String version = AnnotationUtil.get(bean.version());
        if (port >= 0) {
            this.port = port;
        }
        if (actives >= 0) {
            this.actives = actives;
        }
        if (timeout >= 0) {
            this.timeout = timeout;
        }
        if (group != null) {
            this.group = group;
        }
        if (version != null) {
            this.version = version;
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Integer getActives() {
        return this.actives;
    }

    public void setActives(Integer actives) {
        this.actives = actives;
    }

    public String getLoadbalance() {
        return this.loadbalance;
    }

    public void setLoadbalance(String loadbalance) {
        this.loadbalance = loadbalance;
    }

    public Boolean getAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public Boolean getCheck() {
        return this.check;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    public Map<Object, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<Object, Object> params) {
        this.params = params;
    }

    public void addParam(Object key, Object value) {
        if (this.params == null) {
            this.params = new HashMap<Object, Object>();
        }
        this.params.put(key, value);
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

