/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc;

import io.jboot.app.config.annotation.ConfigModel;
import io.jboot.utils.StrUtil;
import java.io.IOException;
import java.net.ServerSocket;

@ConfigModel(prefix="jboot.rpc")
public class JbootrpcConfig {
    public static final String TYPE_DUBBO = "dubbo";
    public static final String TYPE_GRPC = "grpc";
    public static final String TYPE_MOTAN = "motan";
    public static final String TYPE_THRIFT = "thrift";
    public static final String TYPE_LOCAL = "local";
    public static final String TYPE_ZBUS = "zbus";
    public static final String REGISTRY_TYPE_CONSUL = "consul";
    public static final String REGISTRY_TYPE_ZOOKEEPER = "zookeeper";
    public static final String CALL_MODE_REGISTRY = "registry";
    public static final String CALL_MODE_DIRECT = "direct";
    private String type;
    private String callMode = "registry";
    private int requestTimeOut = 5000;
    private String registryType = "consul";
    private String registryAddress = "127.0.0.1:8500";
    private String registryName = "jboot";
    private String registryUserName;
    private String registryPassword;
    private String registryFile;
    private boolean registryCheck = false;
    private boolean consumerCheck = false;
    private boolean providerCheck = false;
    private String directUrl;
    private String host;
    private Integer defaultPort = 0;
    private String defaultGroup = "jboot";
    private String defaultVersion = "1.0";
    private String proxy;
    private String filter;
    private String serialization;
    private Integer retries;
    private boolean autoExportEnable = true;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getRequestTimeOut() {
        return this.requestTimeOut;
    }

    public void setRequestTimeOut(int requestTimeOut) {
        this.requestTimeOut = requestTimeOut;
    }

    public String getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(String registryType) {
        this.registryType = registryType;
    }

    public String getRegistryAddress() {
        return this.registryAddress;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getDefaultPort() {
        if (this.defaultPort == 0) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(0);
                Integer n = serverSocket.getLocalPort();
                return n;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getRegistryUserName() {
        return this.registryUserName;
    }

    public void setRegistryUserName(String registryUserName) {
        this.registryUserName = registryUserName;
    }

    public String getRegistryPassword() {
        return this.registryPassword;
    }

    public void setRegistryPassword(String registryPassword) {
        this.registryPassword = registryPassword;
    }

    public String getRegistryFile() {
        return this.registryFile;
    }

    public void setRegistryFile(String registryFile) {
        this.registryFile = registryFile;
    }

    public String getCallMode() {
        return this.callMode;
    }

    public void setCallMode(String callMode) {
        this.callMode = callMode;
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public void setDirectUrl(String directUrl) {
        if (directUrl != null && directUrl.contains(":")) {
            this.defaultPort = Integer.valueOf(directUrl.split(":")[1]);
        }
        this.directUrl = directUrl;
    }

    public boolean isDirectCallMode() {
        return CALL_MODE_DIRECT.equals(this.getCallMode());
    }

    public boolean isRegistryCallMode() {
        return CALL_MODE_REGISTRY.equals(this.getCallMode());
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isRegistryCheck() {
        return this.registryCheck;
    }

    public void setRegistryCheck(boolean registryCheck) {
        this.registryCheck = registryCheck;
    }

    public boolean isConsumerCheck() {
        return this.consumerCheck;
    }

    public void setConsumerCheck(boolean consumerCheck) {
        this.consumerCheck = consumerCheck;
    }

    public boolean isProviderCheck() {
        return this.providerCheck;
    }

    public void setProviderCheck(boolean providerCheck) {
        this.providerCheck = providerCheck;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public boolean isAutoExportEnable() {
        return this.autoExportEnable;
    }

    public void setAutoExportEnable(boolean autoExportEnable) {
        this.autoExportEnable = autoExportEnable;
    }

    public boolean isConfigOk() {
        return StrUtil.isNotBlank(this.getType());
    }
}

