/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter;

import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import io.jboot.Jboot;
import io.jboot.components.limiter.LimitConfig;
import io.jboot.components.limiter.LimitFallbackProcesser;
import io.jboot.exception.JbootException;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Method;

public class LimitFallbackProcesserDefault
implements LimitFallbackProcesser {
    protected LimitConfig config = Jboot.config(LimitConfig.class);

    @Override
    public void process(String resource, String fallback, Invocation inv) {
        if (StrUtil.isNotBlank(fallback)) {
            this.doProcessFallback(fallback, inv);
            return;
        }
        if (inv.isActionInvocation()) {
            this.doProcessWebLimit(resource, inv);
        } else {
            this.doProcessServiceLimit(resource, inv);
        }
    }

    protected void doProcessFallback(String fallback, Invocation inv) {
        Method method = this.getMethodByName(fallback, inv);
        if (method == null) {
            throw new JbootException("can not find method[" + fallback + "] in class " + ClassUtil.getUsefulClass(inv.getTarget().getClass()));
        }
        try {
            method.setAccessible(true);
            Object invokeValue = method.getParameterCount() == 0 ? method.invoke(inv.getTarget(), new Object[0]) : method.invoke(inv.getTarget(), inv.getArgs());
            inv.setReturnValue(invokeValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Method getMethodByName(String methodName, Invocation inv) {
        Method[] methods;
        Class clazz = ClassUtil.getUsefulClass(inv.getTarget().getClass());
        for (Method m : methods = clazz.getMethods()) {
            if (!methodName.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    protected void doProcessWebLimit(String resource, Invocation inv) {
        Controller controller = inv.getController();
        controller.getResponse().setStatus(this.config.getDefaultHttpCode());
        if (RequestUtil.isAjaxRequest(controller.getRequest())) {
            controller.renderJson(this.config.getDefaultAjaxContent());
        } else {
            String limitView = this.config.getDefaultHtmlView();
            if (limitView != null) {
                controller.render(limitView);
            } else {
                controller.renderText("reqeust limit.");
            }
        }
    }

    protected void doProcessServiceLimit(String resource, Invocation inv) {
        if (Jboot.isDevMode()) {
            System.err.println(resource + " is limited , return null");
        }
    }
}

