/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.event;

import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.components.event.JbootEvent;
import io.jboot.components.event.JbootEventListener;
import io.jboot.components.event.annotation.EventConfig;
import io.jboot.core.weight.WeightUtil;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JbootEventManager {
    private final ExecutorService threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final Map<String, List<JbootEventListener>> asyncListenerMap = new ConcurrentHashMap<String, List<JbootEventListener>>();
    private final Map<String, List<JbootEventListener>> listenerMap = new ConcurrentHashMap<String, List<JbootEventListener>>();
    private static final Log log = Log.getLog(JbootEventManager.class);
    private static JbootEventManager manager;

    public JbootEventManager() {
        this.initListeners();
    }

    public static JbootEventManager me() {
        if (manager == null) {
            manager = ClassUtil.singleton(JbootEventManager.class);
        }
        return manager;
    }

    private void initListeners() {
        List<Class<JbootEventListener>> classes = ClassScanner.scanSubClass(JbootEventListener.class, true);
        if (ArrayUtil.isNullOrEmpty(classes)) {
            return;
        }
        for (Class<JbootEventListener> clazz : classes) {
            this.registerListener(clazz);
        }
    }

    public void unRegisterListener(Class<? extends JbootEventListener> listenerClass) {
        this.deleteListner(this.listenerMap, listenerClass);
        this.deleteListner(this.asyncListenerMap, listenerClass);
        if (Jboot.isDevMode()) {
            log.debug(String.format("listener[%s]-->>unRegisterListener.", listenerClass));
        }
    }

    private void deleteListner(Map<String, List<JbootEventListener>> map, Class<? extends JbootEventListener> listenerClass) {
        for (Map.Entry<String, List<JbootEventListener>> entry : map.entrySet()) {
            JbootEventListener deleteListener = null;
            for (JbootEventListener listener : entry.getValue()) {
                if (listener.getClass() != listenerClass) continue;
                deleteListener = listener;
            }
            if (deleteListener == null) continue;
            entry.getValue().remove(deleteListener);
        }
    }

    public void registerListener(Class<? extends JbootEventListener> listenerClass) {
        if (listenerClass == null) {
            return;
        }
        EventConfig listenerAnnotation = listenerClass.getAnnotation(EventConfig.class);
        if (listenerAnnotation == null) {
            return;
        }
        String[] actions = AnnotationUtil.get(listenerAnnotation.action());
        if (actions == null) {
            log.warn("listenerClass[" + listenerAnnotation + "] register fail, because action is null or blank.");
            return;
        }
        if (this.listenerHasRegisterBefore(listenerClass)) {
            return;
        }
        JbootEventListener listener = ClassUtil.newInstance(listenerClass);
        if (listener == null) {
            return;
        }
        this.registerListener(listener, listenerAnnotation.async(), actions);
    }

    public void unRegisterListener(JbootEventListener eventListener) {
        this.unRegisterListener(eventListener.getClass());
    }

    public void registerListener(JbootEventListener eventListener, boolean async, String ... actions) {
        for (String action : actions) {
            List<JbootEventListener> list;
            List<JbootEventListener> list2 = list = async ? this.asyncListenerMap.get(action) : this.listenerMap.get(action);
            if (null == list) {
                list = new ArrayList<JbootEventListener>();
            }
            if (list.contains(eventListener)) continue;
            list.add(eventListener);
            WeightUtil.sort(list);
            if (async) {
                this.asyncListenerMap.put(action, list);
                continue;
            }
            this.listenerMap.put(action, list);
        }
        if (Jboot.isDevMode()) {
            log.debug(String.format("listener[%s]-->>registered.", eventListener));
        }
    }

    private boolean listenerHasRegisterBefore(Class<? extends JbootEventListener> listenerClass) {
        return this.findFromMap(listenerClass, this.listenerMap) || this.findFromMap(listenerClass, this.asyncListenerMap);
    }

    private boolean findFromMap(Class<? extends JbootEventListener> listenerClass, Map<String, List<JbootEventListener>> map) {
        for (Map.Entry<String, List<JbootEventListener>> entry : map.entrySet()) {
            List<JbootEventListener> listeners = entry.getValue();
            if (listeners == null || listeners.isEmpty()) continue;
            for (JbootEventListener ml : listeners) {
                if (listenerClass != ml.getClass()) continue;
                return true;
            }
        }
        return false;
    }

    public void pulish(JbootEvent event) {
        List<JbootEventListener> listeners;
        String action = event.getAction();
        List<JbootEventListener> syncListeners = this.listenerMap.get(action);
        if (syncListeners != null && !syncListeners.isEmpty()) {
            this.invokeListeners(event, syncListeners);
        }
        if ((listeners = this.asyncListenerMap.get(action)) != null && !listeners.isEmpty()) {
            this.invokeListenersAsync(event, listeners);
        }
    }

    private void invokeListeners(JbootEvent event, List<JbootEventListener> syncListeners) {
        for (JbootEventListener listener : syncListeners) {
            try {
                if (Jboot.isDevMode()) {
                    log.debug(String.format("listener[%s]-->>onEvent(%s)", listener, event));
                }
                listener.onEvent(event);
            }
            catch (Throwable e) {
                log.error(String.format("listener[%s] onEvent is error! ", listener.getClass()), e);
            }
        }
    }

    private void invokeListenersAsync(JbootEvent event, List<JbootEventListener> listeners) {
        for (JbootEventListener listener : listeners) {
            this.threadPool.execute(() -> {
                try {
                    if (Jboot.isDevMode()) {
                        log.debug(String.format("listener[%s]-->>onEvent(%s) in async", listener, event));
                    }
                    listener.onEvent(event);
                }
                catch (Throwable e) {
                    log.error(String.format("listener[%s] onEvent is error! ", listener.getClass()), e);
                }
            });
        }
    }
}

