/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.ehcache;

import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.Jboot;
import io.jboot.components.cache.JbootCacheBase;
import io.jboot.components.cache.ehcache.JbootEhCacheConfig;
import io.jboot.utils.StrUtil;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class JbootEhcacheImpl
extends JbootCacheBase {
    private CacheManager cacheManager;
    private static Object locker = new Object();
    private static final Log log = Log.getLog(JbootEhcacheImpl.class);
    private CacheEventListener cacheEventListener;

    public JbootEhcacheImpl() {
        JbootEhCacheConfig config = Jboot.config(JbootEhCacheConfig.class);
        if (StrUtil.isBlank((String)config.getConfigFileName())) {
            this.cacheManager = CacheManager.create();
        } else {
            String configPath = config.getConfigFileName();
            if (!configPath.startsWith("/")) {
                configPath = PathKit.getRootClassPath() + "/" + configPath;
            }
            this.cacheManager = CacheManager.create((String)configPath);
        }
    }

    public JbootEhcacheImpl(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheEventListener getCacheEventListener() {
        return this.cacheEventListener;
    }

    public void setCacheEventListener(CacheEventListener cacheEventListener) {
        this.cacheEventListener = cacheEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getOrAddCache(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            Object object = locker;
            synchronized (object) {
                cache = this.cacheManager.getCache(cacheName);
                if (cache == null) {
                    log.warn("Could not find cache config [" + cacheName + "], using default.");
                    this.cacheManager.addCacheIfAbsent(cacheName);
                    cache = this.cacheManager.getCache(cacheName);
                    if (this.cacheEventListener != null) {
                        cache.getCacheEventNotificationService().registerListener(this.cacheEventListener);
                    }
                }
            }
        }
        return cache;
    }

    @Override
    public List getKeys(String cacheName) {
        return this.getOrAddCache(cacheName).getKeys();
    }

    @Override
    public <T> T get(String cacheName, Object key) {
        Element element = this.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    @Override
    public void put(String cacheName, Object key, Object value) {
        this.getOrAddCache(cacheName).put(new Element(key, value));
    }

    @Override
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        if (liveSeconds <= 0) {
            this.put(cacheName, key, value);
            return;
        }
        Element element = new Element(key, value);
        element.setTimeToLive(liveSeconds);
        this.getOrAddCache(cacheName).put(element);
    }

    @Override
    public void remove(String cacheName, Object key) {
        this.getOrAddCache(cacheName).remove(key);
    }

    @Override
    public void removeAll(String cacheName) {
        this.getOrAddCache(cacheName).removeAll();
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data);
        }
        return data;
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data, liveSeconds);
        }
        return data;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        Element element = this.getOrAddCache(cacheName).get(key);
        return element != null ? Integer.valueOf(element.getTimeToLive()) : null;
    }

    @Override
    public void setTtl(String cacheName, Object key, int seconds) {
        Element element = this.getOrAddCache(cacheName).get(key);
        if (element == null) {
            return;
        }
        element.setTimeToLive(seconds);
        this.getOrAddCache(cacheName).put(element);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }
}

