/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.codegen;

import com.jfinal.plugin.activerecord.dialect.AnsiSqlDialect;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import com.jfinal.plugin.activerecord.dialect.OracleDialect;
import com.jfinal.plugin.activerecord.dialect.PostgreSqlDialect;
import com.jfinal.plugin.activerecord.dialect.SqlServerDialect;
import com.jfinal.plugin.activerecord.dialect.Sqlite3Dialect;
import com.jfinal.plugin.activerecord.generator.MetaBuilder;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.jboot.Jboot;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

public class CodeGenHelpler {
    public static DataSource getDatasource() {
        DataSourceConfig datasourceConfig = Jboot.config(DataSourceConfig.class, "jboot.datasource");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(datasourceConfig.getUrl());
        config.setUsername(datasourceConfig.getUser());
        config.setPassword(datasourceConfig.getPassword());
        config.setDriverClassName(datasourceConfig.getDriverClassName());
        return new HikariDataSource(config);
    }

    public static MetaBuilder createMetaBuilder() {
        MetaBuilder metaBuilder = new MetaBuilder(CodeGenHelpler.getDatasource());
        DataSourceConfig datasourceConfig = Jboot.config(DataSourceConfig.class, "jboot.datasource");
        switch (datasourceConfig.getType()) {
            case "mysql": {
                metaBuilder.setDialect((Dialect)new MysqlDialect());
                break;
            }
            case "oracle": {
                metaBuilder.setDialect((Dialect)new OracleDialect());
                break;
            }
            case "sqlserver": {
                metaBuilder.setDialect((Dialect)new SqlServerDialect());
                break;
            }
            case "sqlite": {
                metaBuilder.setDialect((Dialect)new Sqlite3Dialect());
                break;
            }
            case "ansisql": {
                metaBuilder.setDialect((Dialect)new AnsiSqlDialect());
                break;
            }
            case "postgresql": {
                metaBuilder.setDialect((Dialect)new PostgreSqlDialect());
                break;
            }
            default: {
                throw new JbootIllegalConfigException("only support datasource type : mysql\u3001orcale\u3001sqlserver\u3001sqlite\u3001ansisql and postgresql, please check your jboot.properties. ");
            }
        }
        return metaBuilder;
    }

    public static void excludeTables(List<TableMeta> list, String excludeTables) {
        if (StrUtil.isNotBlank(excludeTables)) {
            ArrayList<TableMeta> newTableMetaList = new ArrayList<TableMeta>();
            Set<String> excludeTableSet = StrUtil.splitToSet(excludeTables.toLowerCase(), ",");
            for (TableMeta tableMeta : list) {
                if (excludeTableSet.contains(tableMeta.name.toLowerCase())) {
                    System.out.println("exclude table : " + tableMeta.name);
                    continue;
                }
                newTableMetaList.add(tableMeta);
            }
            list.clear();
            list.addAll(newTableMetaList);
        }
    }
}

