/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import io.jboot.app.config.Prop;
import io.jboot.app.config.Utils;
import io.jboot.app.config.annotation.ConfigModel;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class JbootConfigManager {
    private static Map<String, String> argMap;
    private Properties mainProperties;
    private ConcurrentHashMap<String, Object> configCache = new ConcurrentHashMap();
    private static JbootConfigManager instance;
    private Boolean devMode = null;

    public static JbootConfigManager me() {
        if (instance == null) {
            instance = new JbootConfigManager();
        }
        return instance;
    }

    private JbootConfigManager() {
        this.init();
    }

    private void init() {
        File jbf = new File(Utils.getRootClassPath(), "jboot.properties");
        this.mainProperties = !jbf.exists() ? new Properties() : new Prop("jboot.properties").getProperties();
        String mode = this.getConfigValue("jboot.app.mode");
        if (Utils.isNotBlank(mode)) {
            String p = String.format("jboot-%s.properties", mode);
            if (new File(Utils.getRootClassPath(), p).exists()) {
                this.mainProperties.putAll((Map<?, ?>)new Prop(p).getProperties());
            }
        }
    }

    public <T> T get(Class<T> clazz) {
        ConfigModel propertyConfig = clazz.getAnnotation(ConfigModel.class);
        if (propertyConfig == null) {
            return this.get(clazz, null, null);
        }
        return this.get(clazz, propertyConfig.prefix(), propertyConfig.file());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> clazz, String prefix, String file) {
        if (this.isDevMode()) {
            return this.createConfigObject(clazz, prefix, file);
        }
        Object configObject = this.configCache.get(clazz.getName() + prefix);
        if (configObject == null) {
            Class<T> clazz2 = clazz;
            synchronized (clazz2) {
                if (configObject == null) {
                    configObject = this.createConfigObject(clazz, prefix, file);
                    this.configCache.put(clazz.getName() + prefix, configObject);
                }
            }
        }
        return (T)configObject;
    }

    public <T> T createConfigObject(Class<T> clazz, String prefix, String file) {
        T configObject = Utils.newInstance(clazz);
        List<Method> setMethods = Utils.getClassSetMethods(clazz);
        if (setMethods != null) {
            for (Method method : setMethods) {
                String key = this.buildKey(prefix, method);
                String value = this.getConfigValue(key);
                if (Utils.isNotBlank(file)) {
                    try {
                        Prop prop = new Prop(file);
                        String filePropValue = this.getConfigValue(prop.getProperties(), key);
                        if (Utils.isNotBlank(filePropValue)) {
                            value = filePropValue;
                        }
                    }
                    catch (Throwable prop) {
                        // empty catch block
                    }
                }
                try {
                    if (!Utils.isNotBlank(value)) continue;
                    Object val = this.convert(method.getParameterTypes()[0], value);
                    method.invoke(configObject, val);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        return configObject;
    }

    public Object convert(Class<?> type, String s) {
        return Utils.convert(type, s);
    }

    private String buildKey(String prefix, Method method) {
        String key = Utils.firstCharToLowerCase(method.getName().substring(3));
        if (Utils.isNotBlank(prefix)) {
            key = prefix.trim() + "." + key;
        }
        return key;
    }

    public String getConfigValue(String key) {
        return this.getConfigValue(this.mainProperties, key);
    }

    public String getConfigValue(Properties properties, String key) {
        String value = this.getBootArg(key);
        if (Utils.isNotBlank(value)) {
            return value.trim();
        }
        value = System.getenv(key);
        if (Utils.isNotBlank(value)) {
            return value.trim();
        }
        String tempKey = key.toUpperCase().replace('.', '_');
        value = System.getenv(tempKey);
        if (Utils.isNotBlank(value)) {
            return value.trim();
        }
        value = System.getProperty(key);
        if (Utils.isNotBlank(value)) {
            return value.trim();
        }
        value = (String)properties.get(key);
        if (Utils.isNotBlank(value)) {
            return value.trim();
        }
        return null;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.mainProperties);
        if (System.getenv() != null) {
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        if (System.getProperties() != null) {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        if (this.getBootArgs() != null) {
            for (Map.Entry<String, String> entry : this.getBootArgs().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    public void parseArgs(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        for (String arg : args) {
            int indexOf = arg.indexOf("=");
            if (!arg.startsWith("--") || indexOf <= 0) continue;
            String key = arg.substring(2, indexOf);
            String value = arg.substring(indexOf + 1);
            this.setBootArg(key, value);
        }
    }

    public void setBootArg(String key, Object value) {
        if (argMap == null) {
            argMap = new HashMap<String, String>();
        }
        argMap.put(key, value.toString());
    }

    public String getBootArg(String key) {
        if (argMap == null) {
            return null;
        }
        return argMap.get(key);
    }

    public Map<String, String> getBootArgs() {
        return argMap;
    }

    public boolean isDevMode() {
        if (this.devMode == null) {
            String appMode = this.getConfigValue("jboot.app.mode");
            this.devMode = null == appMode || "".equals(appMode.trim()) || "dev".equals(appMode);
        }
        return this.devMode;
    }
}

