/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop.interceptor.cache;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.log.Log;
import io.jboot.aop.interceptor.cache.Utils;
import io.jboot.components.cache.annotation.CacheEvict;
import io.jboot.components.cache.annotation.CachesEvict;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JbootCachesEvictInterceptor
implements Interceptor {
    private static final Log LOG = Log.getLog(JbootCachesEvictInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Invocation inv) {
        Method method = inv.getMethod();
        CachesEvict cachesEvict = method.getAnnotation(CachesEvict.class);
        if (cachesEvict == null) {
            inv.invoke();
            return;
        }
        CacheEvict[] evicts = cachesEvict.value();
        ArrayList<CacheEvict> beforeInvocations = new ArrayList<CacheEvict>();
        ArrayList<CacheEvict> afterInvocations = new ArrayList<CacheEvict>();
        for (CacheEvict evict : evicts) {
            if (evict.beforeInvocation()) {
                beforeInvocations.add(evict);
                continue;
            }
            afterInvocations.add(evict);
        }
        Class<?> targetClass = inv.getTarget().getClass();
        this.doCachesEvict(inv.getArgs(), targetClass, method, beforeInvocations);
        try {
            inv.invoke();
        }
        finally {
            this.doCachesEvict(inv.getArgs(), targetClass, method, afterInvocations);
        }
    }

    private void doCachesEvict(Object[] arguments, Class targetClass, Method method, List<CacheEvict> cacheEvicts) {
        if (cacheEvicts == null || cacheEvicts.isEmpty()) {
            return;
        }
        for (CacheEvict evict : cacheEvicts) {
            try {
                Utils.doCacheEvict(arguments, targetClass, method, evict);
            }
            catch (Exception ex) {
                LOG.error(ex.toString(), (Throwable)ex);
            }
        }
    }
}

