/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop;

import com.jfinal.aop.AopFactory;
import com.jfinal.aop.Enhancer;
import com.jfinal.aop.Inject;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.Controller;
import com.jfinal.kit.LogKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Model;
import io.jboot.aop.InterceptorWapper;
import io.jboot.aop.JbootAopInterceptor;
import io.jboot.aop.annotation.Bean;
import io.jboot.aop.annotation.BeanExclude;
import io.jboot.aop.annotation.ConfigValue;
import io.jboot.aop.annotation.StaticConstruct;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.annotation.ConfigModel;
import io.jboot.components.event.JbootEventListener;
import io.jboot.components.mq.JbootmqMessageListener;
import io.jboot.components.rpc.Jbootrpc;
import io.jboot.components.rpc.JbootrpcManager;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.annotation.RPCInject;
import io.jboot.db.model.JbootModel;
import io.jboot.service.JbootServiceBase;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootController;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class JbootAopFactory
extends AopFactory {
    private static final Log LOG = Log.getLog(JbootAopFactory.class);
    private static final Class[] DEFAULT_EXCLUDES_MAPPING_CLASSES = new Class[]{JbootEventListener.class, JbootmqMessageListener.class, Serializable.class};
    private static JbootAopFactory me = new JbootAopFactory();
    protected List<InterceptorWapper> interceptorWappers = Collections.synchronizedList(new ArrayList());
    protected InterceptorWapper defaultAopInterceptor = new InterceptorWapper(new JbootAopInterceptor());
    private Interceptor[] aopInterceptors;

    public static JbootAopFactory me() {
        return me;
    }

    private JbootAopFactory() {
        this.setInjectSuperClass(true);
        this.initBeanMapping();
    }

    public JbootAopFactory addInterceptor(Interceptor interceptor) {
        this.interceptorWappers.add(new InterceptorWapper(interceptor));
        this.clearInterceptorsAndObjectCache();
        return this;
    }

    public JbootAopFactory addInterceptor(Interceptor interceptor, int orderNo) {
        this.interceptorWappers.add(new InterceptorWapper(interceptor, orderNo));
        this.clearInterceptorsAndObjectCache();
        return this;
    }

    public List<InterceptorWapper> getInterceptorWappers() {
        return this.interceptorWappers;
    }

    public Interceptor[] getAopInterceptors() {
        return this.aopInterceptors;
    }

    protected void clearInterceptorsAndObjectCache() {
        this.aopInterceptors = null;
        this.singletonCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Interceptor[] buildAopInterceptors() {
        if (this.aopInterceptors != null) {
            return this.aopInterceptors;
        }
        JbootAopFactory jbootAopFactory = this;
        synchronized (jbootAopFactory) {
            if (this.aopInterceptors == null) {
                if (!this.interceptorWappers.contains(this.defaultAopInterceptor)) {
                    this.interceptorWappers.add(this.defaultAopInterceptor);
                }
                this.interceptorWappers.sort(Comparator.comparingInt(InterceptorWapper::getOrderNo));
                Interceptor[] interceptors = new Interceptor[this.interceptorWappers.size()];
                int i = 0;
                for (InterceptorWapper w : this.interceptorWappers) {
                    interceptors[i++] = w.getInterceptor();
                }
                this.aopInterceptors = interceptors;
            }
        }
        return this.aopInterceptors;
    }

    protected Object createObject(Class<?> targetClass) {
        ConfigModel configModel = targetClass.getAnnotation(ConfigModel.class);
        if (configModel != null) {
            return JbootConfigManager.me().get(targetClass);
        }
        StaticConstruct staticConstruct = targetClass.getAnnotation(StaticConstruct.class);
        if (staticConstruct != null) {
            return ClassUtil.newInstanceByStaticConstruct(targetClass, staticConstruct);
        }
        return Enhancer.enhance(targetClass, (Interceptor[])this.buildAopInterceptors());
    }

    protected void doInject(Class<?> targetClass, Object targetObject) throws ReflectiveOperationException {
        Class c;
        Field[] fields = (targetClass = this.getUsefulClass(targetClass)).getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                Inject inject = field.getAnnotation(Inject.class);
                if (inject != null) {
                    this.doInjectJFinalOrginal(targetObject, field, inject);
                    continue;
                }
                ConfigValue configValue = field.getAnnotation(ConfigValue.class);
                if (configValue != null) {
                    this.doInjectConfigValue(targetObject, field, configValue);
                    continue;
                }
                RPCInject rpcInject = field.getAnnotation(RPCInject.class);
                if (rpcInject == null) continue;
                this.doInjectRPC(targetObject, field, rpcInject);
            }
        }
        if (this.injectSuperClass && (c = targetClass.getSuperclass()) != JbootController.class && c != Controller.class && c != JbootServiceBase.class && c != Object.class && c != JbootModel.class && c != Model.class && c != null) {
            this.doInject(c, targetObject);
        }
    }

    private void doInjectJFinalOrginal(Object targetObject, Field field, Inject inject) throws ReflectiveOperationException {
        Class<?> fieldInjectedClass = inject.value();
        if (fieldInjectedClass == Void.class) {
            fieldInjectedClass = field.getType();
        }
        Object fieldInjectedObject = this.doGet(fieldInjectedClass);
        this.setFiled(field, targetObject, fieldInjectedObject);
    }

    private void doInjectRPC(Object targetObject, Field field, RPCInject rpcInject) {
        try {
            JbootrpcServiceConfig serviceConfig = new JbootrpcServiceConfig(rpcInject);
            Class<?> fieldInjectedClass = field.getType();
            Jbootrpc jbootrpc = JbootrpcManager.me().getJbootrpc();
            Object fieldInjectedObject = jbootrpc.serviceObtain(fieldInjectedClass, serviceConfig);
            this.setFiled(field, targetObject, fieldInjectedObject);
        }
        catch (Exception ex) {
            LOG.error("can not inject rpc service in " + targetObject.getClass() + " by config " + rpcInject, (Throwable)ex);
        }
    }

    private void doInjectConfigValue(Object targetObject, Field field, ConfigValue configValue) throws IllegalAccessException {
        String key = AnnotationUtil.get(configValue.value());
        Class<?> fieldInjectedClass = field.getType();
        String value = this.getConfigValue(key, targetObject, field);
        if (StrUtil.isNotBlank(value)) {
            Object fieldInjectedObject = JbootConfigManager.me().convert(fieldInjectedClass, value);
            this.setFiled(field, targetObject, fieldInjectedObject);
            return;
        }
        if (configValue.requireNullOrBlank()) {
            field.setAccessible(true);
            if (fieldInjectedClass == Integer.TYPE) {
                field.set(targetObject, 0);
            } else if (fieldInjectedClass == Boolean.TYPE) {
                field.set(targetObject, false);
            } else {
                field.set(targetObject, null);
            }
        }
    }

    private String getConfigValue(String key, Object targetObject, Field field) {
        return AnnotationUtil.getConfigValueByKeyString(key);
    }

    public synchronized <T> AopFactory addMapping(Class<T> from, Class<? extends T> to) {
        Class mappingClass;
        if (from == null || to == null) {
            throw new IllegalArgumentException("The parameter from and to can not be null");
        }
        if (this.mapping == null) {
            this.mapping = new HashMap(128, 0.25f);
        }
        if ((mappingClass = (Class)this.mapping.get(from)) != null) {
            if (mappingClass == to) {
                return this;
            }
            this.singletonCache.remove(mappingClass);
            LogKit.warn((String)("Aop Class[" + from + "] mapping changed from  " + mappingClass + " to " + to));
        }
        this.mapping.put(from, to);
        return this;
    }

    protected void setFiled(Field filed, Object toObj, Object data) throws IllegalAccessException {
        if (!filed.isAccessible()) {
            filed.setAccessible(true);
        }
        filed.set(toObj, data);
    }

    private void initBeanMapping() {
        List<Class> classes = ClassScanner.scanClassByAnnotation(Bean.class, true);
        for (Class implClass : classes) {
            Class<?>[] interfaceClasses = implClass.getInterfaces();
            if (interfaceClasses == null || interfaceClasses.length == 0) continue;
            Class[] excludes = this.buildExcludeClasses(implClass);
            for (Class<?> interfaceClass : interfaceClasses) {
                if (this.inExcludes(interfaceClass, excludes)) continue;
                this.addMapping(interfaceClass, implClass);
            }
        }
    }

    private Class[] buildExcludeClasses(Class implClass) {
        BeanExclude beanExclude = implClass.getAnnotation(BeanExclude.class);
        return beanExclude == null ? DEFAULT_EXCLUDES_MAPPING_CLASSES : ArrayUtil.concat(DEFAULT_EXCLUDES_MAPPING_CLASSES, new Class[][]{beanExclude.value()});
    }

    private boolean inExcludes(Class interfaceClass, Class[] excludes) {
        for (Class ex : excludes) {
            if (!ex.isAssignableFrom(interfaceClass)) continue;
            return true;
        }
        return false;
    }
}

