/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.http.client.pool;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.http.client.pool.ResourceContainer;
import io.druid.java.util.http.client.pool.ResourceFactory;
import io.druid.java.util.http.client.pool.ResourcePoolConfig;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class ResourcePool<K, V>
implements Closeable {
    private static final Logger log = new Logger(ResourcePool.class);
    private final LoadingCache<K, ImmediateCreationResourceHolder<K, V>> pool;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ResourcePool(final ResourceFactory<K, V> factory, final ResourcePoolConfig config) {
        this.pool = CacheBuilder.newBuilder().build(new CacheLoader<K, ImmediateCreationResourceHolder<K, V>>(){

            public ImmediateCreationResourceHolder<K, V> load(K input) throws Exception {
                return new ImmediateCreationResourceHolder(config.getMaxPerKey(), config.getUnusedConnectionTimeoutMillis(), input, factory);
            }
        });
    }

    public ResourceContainer<V> take(final K key) {
        ImmediateCreationResourceHolder holder;
        if (this.closed.get()) {
            log.error(StringUtils.format("take(%s) called even though I'm closed.", key), new Object[0]);
            return null;
        }
        try {
            holder = (ImmediateCreationResourceHolder)this.pool.get(key);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        final Object value = holder.get();
        return new ResourceContainer<V>(){
            private final AtomicBoolean returned = new AtomicBoolean(false);

            @Override
            public V get() {
                Preconditions.checkState((!this.returned.get() ? 1 : 0) != 0, (String)"Resource for key[%s] has been returned, cannot get().", (Object[])new Object[]{key});
                return value;
            }

            @Override
            public void returnResource() {
                if (this.returned.getAndSet(true)) {
                    log.warn(StringUtils.format("Resource at key[%s] was returned multiple times?", key), new Object[0]);
                } else {
                    holder.giveBack(value);
                }
            }

            protected void finalize() throws Throwable {
                if (!this.returned.get()) {
                    log.warn(StringUtils.format("Resource[%s] at key[%s] was not returned before Container was finalized, potential resource leak.", value, key), new Object[0]);
                    this.returnResource();
                }
                super.finalize();
            }
        };
    }

    @Override
    public void close() {
        this.closed.set(true);
        ConcurrentMap mapView = this.pool.asMap();
        for (Object k : ImmutableSet.copyOf(mapView.keySet())) {
            ((ImmediateCreationResourceHolder)mapView.remove(k)).close();
        }
    }

    private static class ResourceHolder<V> {
        private long lastAccessedTime;
        private V resource;

        public ResourceHolder(long lastAccessedTime, V resource) {
            this.resource = resource;
            this.lastAccessedTime = lastAccessedTime;
        }

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public V getResource() {
            return this.resource;
        }
    }

    private static class ImmediateCreationResourceHolder<K, V> {
        private final int maxSize;
        private final K key;
        private final ResourceFactory<K, V> factory;
        private final ArrayDeque<ResourceHolder<V>> resourceHolderList;
        private int deficit = 0;
        private boolean closed = false;
        private final long unusedResourceTimeoutMillis;

        private ImmediateCreationResourceHolder(int maxSize, long unusedResourceTimeoutMillis, K key, ResourceFactory<K, V> factory) {
            this.maxSize = maxSize;
            this.key = key;
            this.factory = factory;
            this.unusedResourceTimeoutMillis = unusedResourceTimeoutMillis;
            this.resourceHolderList = new ArrayDeque();
            for (int i = 0; i < maxSize; ++i) {
                this.resourceHolderList.add(new ResourceHolder<Object>(System.currentTimeMillis(), Preconditions.checkNotNull(factory.generate(key), (Object)"factory.generate(key)")));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V get() {
            V retVal;
            V poolVal;
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                while (!this.closed && this.resourceHolderList.size() == 0 && this.deficit == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        return null;
                    }
                }
                if (this.closed) {
                    log.info(StringUtils.format("get() called even though I'm closed. key[%s]", this.key), new Object[0]);
                    return null;
                }
                if (!this.resourceHolderList.isEmpty()) {
                    ResourceHolder<V> holder = this.resourceHolderList.removeFirst();
                    if (System.currentTimeMillis() - holder.getLastAccessedTime() > this.unusedResourceTimeoutMillis) {
                        this.factory.close(holder.getResource());
                        poolVal = this.factory.generate(this.key);
                    } else {
                        poolVal = holder.getResource();
                    }
                } else if (this.deficit > 0) {
                    --this.deficit;
                    poolVal = null;
                } else {
                    throw new IllegalStateException("WTF?! No objects left, and no object deficit. This is probably a bug.");
                }
            }
            try {
                if (poolVal != null && this.factory.isGood(poolVal)) {
                    retVal = poolVal;
                } else {
                    if (poolVal != null) {
                        this.factory.close(poolVal);
                    }
                    retVal = this.factory.generate(this.key);
                }
            }
            catch (Throwable e) {
                ImmediateCreationResourceHolder immediateCreationResourceHolder2 = this;
                synchronized (immediateCreationResourceHolder2) {
                    ++this.deficit;
                    this.notifyAll();
                }
                throw Throwables.propagate((Throwable)e);
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void giveBack(V object) {
            Preconditions.checkNotNull(object, (Object)"object");
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                if (this.closed) {
                    log.info(StringUtils.format("giveBack called after being closed. key[%s]", this.key), new Object[0]);
                    this.factory.close(object);
                    return;
                }
                if (this.resourceHolderList.size() >= this.maxSize) {
                    if (this.holderListContains(object)) {
                        log.warn(StringUtils.format("Returning object[%s] at key[%s] that has already been returned!? Skipping", object, this.key), new Exception("Exception for stacktrace"));
                    } else {
                        log.warn(StringUtils.format("Returning object[%s] at key[%s] even though we already have all that we can hold[%s]!? Skipping", object, this.key, this.resourceHolderList), new Exception("Exception for stacktrace"));
                    }
                    return;
                }
                this.resourceHolderList.addLast(new ResourceHolder<V>(System.currentTimeMillis(), object));
                this.notifyAll();
            }
        }

        private boolean holderListContains(V object) {
            return this.resourceHolderList.stream().anyMatch(a -> a.getResource().equals(object));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                this.closed = true;
                this.resourceHolderList.forEach((Consumer<ResourceHolder<V>>)((Consumer<ResourceHolder>)v -> this.factory.close(v.getResource())));
                this.resourceHolderList.clear();
                this.notifyAll();
            }
        }
    }
}

