/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.emitter.service;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.emitter.service.ServiceEvent;
import java.util.Collections;
import java.util.Map;
import org.joda.time.DateTime;

public class AlertEvent
implements ServiceEvent {
    private final ImmutableMap<String, String> serviceDimensions;
    private final Severity severity;
    private final String description;
    private final DateTime createdTime;
    private final Map<String, Object> dataMap;

    public AlertEvent(DateTime createdTime, ImmutableMap<String, String> serviceDimensions, Severity severity, String description, Map<String, Object> dataMap) {
        this.createdTime = createdTime;
        this.serviceDimensions = serviceDimensions;
        this.severity = severity;
        this.description = description;
        this.dataMap = dataMap;
    }

    public AlertEvent(DateTime createdTime, String service, String host, Severity severity, String description, Map<String, Object> dataMap) {
        this(createdTime, (ImmutableMap<String, String>)ImmutableMap.of((Object)"service", (Object)service, (Object)"host", (Object)host), severity, description, dataMap);
    }

    public AlertEvent(String service, String host, Severity severity, String description, Map<String, Object> dataMap) {
        this(DateTimes.nowUtc(), service, host, severity, description, dataMap);
    }

    public AlertEvent(String service, String host, String description, Map<String, Object> dataMap) {
        this(DateTimes.nowUtc(), service, host, Severity.DEFAULT, description, dataMap);
    }

    public AlertEvent(String service, String host, String description) {
        this(DateTimes.nowUtc(), service, host, Severity.DEFAULT, description, (Map<String, Object>)ImmutableMap.of());
    }

    @Override
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getFeed() {
        return "alerts";
    }

    @Override
    public String getService() {
        return (String)this.serviceDimensions.get((Object)"service");
    }

    @Override
    public String getHost() {
        return (String)this.serviceDimensions.get((Object)"host");
    }

    @Override
    public boolean isSafeToBuffer() {
        return false;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getDataMap() {
        return Collections.unmodifiableMap(this.dataMap);
    }

    @Override
    @JsonValue
    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put((Object)"feed", (Object)this.getFeed()).put((Object)"timestamp", (Object)this.createdTime.toString()).putAll(this.serviceDimensions).put((Object)"severity", (Object)this.severity.toString()).put((Object)"description", (Object)this.description).put((Object)"data", this.dataMap).build();
    }

    public static enum Severity {
        ANOMALY{

            public String toString() {
                return "anomaly";
            }
        }
        ,
        COMPONENT_FAILURE{

            public String toString() {
                return "component-failure";
            }
        }
        ,
        SERVICE_FAILURE{

            public String toString() {
                return "service-failure";
            }
        };

        public static final Severity DEFAULT;

        static {
            DEFAULT = COMPONENT_FAILURE;
        }
    }
}

